*******************************************************************************************
*     UTILITY TO ANALYSE EPAQ2 DATA, ENTERED AND CLEANED ACCORDING TO EPIC/MRC GUIDELINES *
*                                                                                         *
*     NOTE: If your data set contains more than one questionnaire version, you MUST       *
*           split it into one file for v1/2 and one for v4/5 or things will go wrong...   *
*     NOTE: If your first record has a missing value for version, this script will not    *
*           work; change the file sort order so that the first record has a version value *  
*	  NOTE: This script uses median values within dataset for missing imputation!	      *
*																						  *
*	Authors: Marcel den Hoed, Soren Brage (MRC Epidemiology Unit, Cambridge, UK)		  *
*   v3.1/3.2 edits: Clare Boothby (MRC Epidemiology Unit, Cambridge, UK)				  *
*	v3.3/3.4 edits: Soren Brage															  *
*	v3.5/3.6 edits: LG/KW																		  *
*******************************************************************************************

/*
Version history from Clare:
v3.0 - script as of Nov 2011
v3.1 - corrected calculation of unaccounted time, plus a few smaller bug fixes - Mar 2012
v3.2 - added code to calculate number of leisure activities with missing data - July 2012
v3.3 - added PAEE variables - May 2013
v3.4 - split missing job query by version. Added timestamp to output file. Sept 2013
v3.5 - added in ignore(":") to destring command for the wkdaybed wkdayup wkendbed wkendup variables - Oct 2013
v3.6 - replacing activity durations to missing (previously left as minuses) & destring extra variables - Nov 2013
*/

clear*
set more off
set mem 600m
*capture log close

local FOLDER = ""

local INPUT_FILE = ""

local pc_date = c(current_date)
local date = subinstr("`pc_date'", " ", "", .)

local INPUT_STUMP = subinstr("`INPUT_FILE'", ".dta", "", .)
local OUTPUT_FILE = "`INPUT_STUMP'_PROCESS`date'.dta"

* DATA MANAGEMENT OVERVIEW *
di "INPUT file is `INPUT_FILE' in location `FOLDER'"
di "OUTPUT file will be `OUTPUT_FILE'"

* * * * * * * * PROCESSING * * * * * * *

cd "`FOLDER'"
use "`INPUT_FILE'", clear

count
local N=r(N)
	if `N'<1000 {
		di "This dataset includes less than 1000 individuals"
		di "Please note that in many cases, missing values will be imputed using in-sample median values for those particular variables"
		di "If you are happy with this approach, just comment out the stop line below (add * at beginning of line) and rerun the script"
		stop
			}

destring version, replace 

if version>=1 & version<=5 {
destring wkdaybed wkdayup wkendbed wkendup, ignore(":") replace
}

if version>=1 & version<=2 {
destring caruse pub_tran bikedist walkdist bike1 bike2 bike3 bike4 bike5 bike6 ///
walk1 walk2 walk3 walk4 walk5 walk6, replace
}

if version>=4 & version<=5 {
destring distance1 distance2 distance3, replace
}

destring wkdaytv wkevetv wedaytv weevetv westair wkstair, replace

destring sex prepfood shopfood shopelse cleanhse laundry babycare oldcare, replace

if version>=1 & version<=2 {
destring jonehr jonemo jtwohr jtwomo jthrhr jthrmo othonet othtwot, replace
destring act2one act2thr act2two actone actthr acttwo, replace
destring sitaone sitbone staaone stabone stacone stadone walaone walbone movone stairone laddone kneel squat get_up, replace
destring sitatwo sitbtwo staatwo stabtwo stactwo stadtwo walatwo walbtwo movtwo stairtwo laddtwo, replace
destring sitathr sitbthr staathr stabthr stacthr stadthr walathr walbthr movthr stairthr laddthr, replace
destring noone notwo nothr mlone mltwo mlthr, replace 
destring carone pubone bikone walone cartwo pubtwo biktwo waltwo carthr pubthr bikthr walthr, replace
}

if version>=4 & version<=5 {
destring jonehr jonemo jtwohr jtwomo, replace
destring sitaone sitbone staaone stabone stacone stadone walaone walbone movone j1kneel j1squat j1getup, replace
destring sitatwo sitbtwo staatwo stabtwo stactwo stadtwo walatwo walbtwo movtwo j2kneel j2squat j2getup, replace
destring noone notwo mlone mltwo, replace 
destring carone pubone bikone walone cartwo pubtwo biktwo waltwo , replace
}

if version>=4 & version<=5 {
gen skif = .
gen skiinghr_cleaned = .
gen skiingmin_cleaned = .
gen othonef = .
gen othtwof = .
}

if version>=1 & version<=2 {
destring aerot aerof bakpakf bakpakt bowlf bowlt boxf boxt ///
comrunf comrunt crickf crickt cycplef cycplet cycracf cycract dancef dancet digf digt diyf diyt ///
exerf exert fishf fisht floorf floort footf foott golff golft horsef horset jogf jogt lapswif lapswit lawnf lawnt ///
lesswif lesswit musicf musict netf nett othonef othonet othtwof othtwot  ///
rowf rowt sailf sailt skatef skatet skif skit snookf snookt squashf squasht stepf stept tabtenf tabtent ///
tenbadf tenbadt walkf walkt waterf watert weedf weedt wghtf wghtt , replace
}

if version>=4 & version<=5 {
destring  aerof bakpakf  bowlf  boxf  ///
comrunf  crickf  cycplef  cycracf  dancef  digf  diyf  ///
exerf  fishf  floorf  footf  golff  horsef  j1getup  j1kneel  j1ladder  j1squat  ///
j1stairs  j2getup  j2kneel  j2ladder  j2squat  j2stairs  jogf  lapswif  lawnf  ///
lesswif  movoneh  movtwoh  musicf  netf  othonef  othtwof   ///
rowf  sailf  sitaoneh  sitatwoh  sitboneh  skatef  skif  snookf  squashf  staaoneh ///
staatwoh  staboneh  stabtwoh  staconeh stactwoh  stadoneh  stadtwoh  stepf  tabtenf  ///
tenbadf  walaoneh  walatwoh  walboneh  walbtwoh  walkf  walone  waterf  weedf  wghtf  wkdaybed  , replace

destring swimcomphr_cleaned swimcompmin_cleaned swimleishr_cleaned swimleismin_cleaned backpackmountainclimbhr_cleaned backpackmountainclimbmin_cleaned ///
 walkpleasurehr_cleaned walkpleasuremin_cleaned cyclingracingroughhr_cleaned cyclingracingroughmin_cleaned cyclepleasurehr_cleaned cyclepleasuremin_cleaned ///
 mowinghr_cleaned mowingmin_cleaned waterlawnhr_cleaned waterlawnmin_cleaned heavygardeninghr_cleaned heavygardeningmin_cleaned ///
 weedprunehr_cleaned weedprunemin_cleaned diyhr_cleaned diymin_cleaned aerobicshighhr_cleaned aerobicshighmin_cleaned ///
 aerobicsotherhr_cleaned aerobicsothermin_cleaned exerciseweightshr_cleaned exerciseweightsmin_cleaned ///
 conditionexercisehr_cleaned conditionexercisemin_cleaned floorexercisehr_cleaned floorexercisemin_cleaned ///
 dancinghr_cleaned dancingmin_cleaned comprunhr_cleaned comprunmin_cleaned joghr_cleaned jogmin_cleaned ///
 bowlinghr_cleaned bowlingmin_cleaned tennisbadmintonhr_cleaned tennisbadmintonmin_cleaned squashhr_cleaned squashmin_cleaned ///
 tabletennishr_cleaned tabletennismin_cleaned golfhr_cleaned golfmin_cleaned footballrugbyhockeyhr_cleaned footballrugbyhockeymin_cleaned ///
 crickethr_cleaned cricketmin_cleaned rowinghr_cleaned rowingmin_cleaned netvolleybasketballhr_cleaned netvolleybasketballmin_cleaned ///
 huntingshootingfishinghr_cle huntingshootingfishingmin_cle horsebasedhr_cleaned horsebasedmin_cleaned snookerbillardsdartshr_clea snookerbillardsdartsmin_clea ///
 musicalinstrumentsinginghr_clea musicalinstrumentsingingmin_clea iceskatinghr_cleaned iceskatingmin_cleaned sailingwindsurfboatinghr_clea sailingwindsurfboatingmin_clea combatssportshr_cleaned combatssportsmin_cleaned, replace
}


*replace version = 1 if version ==5

rename wkdaytv MEDIAWEEKDAYPRE6PM
rename wkevetv MEDIAWEEKDAYPOST6PM
rename wedaytv MEDIAWEEKENDDAYPRE6PM
rename weevetv MEDIAWEEKENDDAYPOST6PM

rename wkstair STAIRCLIMBINGWEEKDAY
rename westair STAIRCLIMBINGWEEKENDDAY

rename mlone wrkmiles_cleaned1
rename noone commutenoone_cleaned
rename mltwo wrkmiles_cleaned2
rename notwo commutenotwo_cleaned

if version>=1 & version<=2 {
rename mlthr wrkmiles_cleaned3
rename nothr commutenothr_cleaned
}

*GENERATE MISSINGS as per data entry codes
cap order studyid de_initials jobone jobthr jobtwo othact2 otheract othonen othtwon
*assume variables come in specified order
 
 *assumes missing data is entered as negative value.
 
if version>=1 & version<=2 {
foreach var of varlist act2one act2oneh act2thr act2thrh act2two act2twoh actone actoneh actthr actthrh ///
acttwo acttwoh aerof aerot babycare bakpakf bakpakt bike1 bike2 bike3 bike4 bike5 bike6 bikedist bikeno bikone bikthr biktwo ///
bowlf bowlt boxf boxt carone carthr cartwo caruse cleanhse comrunf comrunt crickf crickt cycplef cycplet cycracf cycract ///
dancef dancet digf digt diyf diyt exerf exert fishf fisht floorf floort footf foott get_up golff golft horsef horset jogf jogt ///
jonehr jonemo jthrhr jthrmo jtwohr jtwomo kneel laddone laddthr laddtwo lapswif lapswit laundry lawnf lawnt lesswif lesswit ///
met1 met2 wrkmiles_cleaned1 wrkmiles_cleaned3 wrkmiles_cleaned2 movone movoneh movthr movthrh movtwo movtwoh musicf musict ///
netf nett commutenoone_cleaned commutenothr_cleaned commutenotwo_cleaned oldcare othonef othonet othtwof othtwot prepfood ///
pubone pubthr pubtwo pub_tran rowf rowt sailf sailt sex shopelse shopfood sitaone sitaoneh sitathr sitathrh sitatwo sitatwoh ///
sitbone sitboneh sitbthr sitbthrh sitbtwo sitbtwoh skatef skatet skif skit snookf snookt squashf squasht squat staaone staaoneh ///
staathr staathrh staatwo staatwoh stabone staboneh stabthr stabthrh stabtwo stabtwoh stacone staconeh stacthr stacthrh stactwo ///
stactwoh stadone stadoneh stadthr stadthrh stadtwo stadtwoh stairone stairthr stairtwo stepf stept tabtenf tabtent tenbadf tenbadt ///
walaone walaoneh walathr walathrh walatwo walatwoh walbone walboneh walbthr walbthrh walbtwo walbtwoh ///
walk1 walk2 walk3 walk4 walk5 walk6 walkdist walkf walkno walkt walone walthr waltwo waterf watert ///
MEDIAWEEKENDDAYPRE6PM weedf weedt MEDIAWEEKENDDAYPOST6PM STAIRCLIMBINGWEEKENDDAY wghtf wghtt wkdaybed ///
MEDIAWEEKDAYPRE6PM wkdayup wkendbed wkendup MEDIAWEEKDAYPOST6PM STAIRCLIMBINGWEEKDAY {
	replace `var'=. if `var' < 0 
	}
}

if version>=4 & version<=5 {
foreach var of varlist aerof babycare bakpakf distance1 distance2 distance3 bikone biktwo ///
bowlf boxf carone cartwo cleanhse comrunf crickf cycplef cycracf ///
dancef digf diyf exerf fishf floorf footf golff horsef jogf ///
jonehr jonemo jtwohr jtwomo j1stairs j2stairs j1ladder j2ladder j1kneel j2kneel j1squat j2squat j1getup j2getup ///
lapswif laundry lawnf lesswif ///
wrkmiles_cleaned1 wrkmiles_cleaned2 movone movoneh movtwo movtwoh musicf ///
netf commutenoone_cleaned commutenotwo_cleaned oldcare othonef othtwof prepfood ///
pubone pubtwo rowf sailf sex shopelse shopfood sitaone sitaoneh sitatwo sitatwoh ///
sitbone sitboneh sitbtwo sitbtwoh skatef skif snookf squashf staaone staaoneh ///
staatwo staatwoh stabone staboneh stabtwo stabtwoh stacone staconeh stactwo ///
stactwoh stadone stadoneh stadtwo stadtwoh stepf tabtenf tenbadf ///
walaone walaoneh walatwo walatwoh walbone walboneh walbtwo walbtwoh ///
walkf walone waltwo waterf ///
MEDIAWEEKENDDAYPRE6PM weedf MEDIAWEEKENDDAYPOST6PM STAIRCLIMBINGWEEKENDDAY wghtf wkdaybed ///
MEDIAWEEKDAYPRE6PM wkdayup wkendbed wkendup MEDIAWEEKDAYPOST6PM STAIRCLIMBINGWEEKDAY {
	di `var'
	replace `var'=. if `var' < 0 
	}
/* replacing missing for durations */
foreach x in swimcomp swimleis backpackmountainclimb  walkpleasure cyclingracingrough cyclepleasure mowing waterlawn heavygardening ///
weedprune diy aerobicshigh aerobicsother exerciseweights conditionexercise floorexercise dancing comprun jog bowling tennisbadminton ///
squash tabletennis golf footballrugbyhockey cricket rowing netvolleybasketball huntingshootingfishing horsebased snookerbillardsdarts ///
musicalinstrumentsinging iceskating sailingwindsurfboating skiing combatssports {
	replace `x'hr_cl = . if `x'hr_cl <0
	replace `x'min_cl = . if `x'min_cl <0
}
}

*convert time from hours and minutes to decimal time
if version>=1 & version<=2 {
gen swimcomphr_cleaned = floor(lapswit)
gen swimcompmin_cleaned = 100*(lapswit - swimcomphr_cleaned)
replace swimcomphr_cleaned = swimcomphr_cleaned+1 if swimcompmin_cleaned >=60 & swimcompmin_cleaned!=.
replace swimcompmin_cleaned = swimcompmin_cleaned-60 if swimcompmin_cleaned >=60 & swimcompmin_cleaned!=.


gen swimleishr_cleaned = floor(lesswit)
gen swimleismin_cleaned = 100*(lesswit - swimleishr_cleaned)
replace swimleishr_cleaned = swimleishr_cleaned+1 if swimleismin_cleaned >=60 & swimleismin_cleaned!=.
replace swimleismin_cleaned = swimleismin_cleaned-60 if swimleismin_cleaned >=60 & swimleismin_cleaned!=.

gen backpackmountainclimbhr_cleaned = floor(bakpakt)
gen backpackmountainclimbmin_cleaned = 100*(bakpakt - backpackmountainclimbhr_cleaned)
replace backpackmountainclimbhr_cleaned = backpackmountainclimbhr_cleaned+1 if backpackmountainclimbmin_cleaned >=60 & backpackmountainclimbmin_cleaned!=.
replace backpackmountainclimbmin_cleaned = backpackmountainclimbmin_cleaned-60 if backpackmountainclimbmin_cleaned >=60 & backpackmountainclimbmin_cleaned!=.

gen walkpleasurehr_cleaned = floor(walkt)
gen walkpleasuremin_cleaned = 100*(walkt - walkpleasurehr_cleaned)
replace walkpleasurehr_cleaned = walkpleasurehr_cleaned+1 if walkpleasuremin_cleaned >=60 & walkpleasuremin_cleaned!=.
replace walkpleasuremin_cleaned = walkpleasuremin_cleaned-60 if walkpleasuremin_cleaned >=60 & walkpleasuremin_cleaned!=.

gen cyclingracingroughhr_cleaned = floor(cycract)
gen cyclingracingroughmin_cleaned = 100*(cycract - cyclingracingroughhr_cleaned)
replace cyclingracingroughhr_cleaned = cyclingracingroughhr_cleaned+1 if cyclingracingroughmin_cleaned >=60 & cyclingracingroughmin_cleaned!=.
replace cyclingracingroughmin_cleaned = cyclingracingroughmin_cleaned-60 if cyclingracingroughmin_cleaned >=60 & cyclingracingroughmin_cleaned!=.

gen cyclepleasurehr_cleaned = floor(cycplet)
gen cyclepleasuremin_cleaned = 100*(cycplet - cyclepleasurehr_cleaned)
replace cyclepleasurehr_cleaned = cyclepleasurehr_cleaned+1 if cyclepleasuremin_cleaned >=60 & cyclepleasuremin_cleaned!=.
replace cyclepleasuremin_cleaned = cyclepleasuremin_cleaned-60 if cyclepleasuremin_cleaned >=60 & cyclepleasuremin_cleaned!=.

gen mowinghr_cleaned = floor(lawnt)
gen mowingmin_cleaned = 100*(lawnt - mowinghr_cleaned)
replace mowinghr_cleaned = mowinghr_cleaned+1 if mowingmin_cleaned >=60 & mowingmin_cleaned!=.
replace mowingmin_cleaned = mowingmin_cleaned-60 if mowingmin_cleaned >=60 & mowingmin_cleaned!=.

gen waterlawnhr_cleaned = floor(watert)
gen waterlawnmin_cleaned = 100*(watert - waterlawnhr_cleaned)
replace waterlawnhr_cleaned = waterlawnhr_cleaned+1 if waterlawnmin_cleaned >=60 & waterlawnmin_cleaned!=.
replace waterlawnmin_cleaned = waterlawnmin_cleaned-60 if waterlawnmin_cleaned >=60 & waterlawnmin_cleaned!=.

gen heavygardeninghr_cleaned = floor(digt)
gen heavygardeningmin_cleaned = 100*(digt - heavygardeninghr_cleaned)
replace heavygardeninghr_cleaned = heavygardeninghr_cleaned+1 if heavygardeningmin_cleaned >=60 & heavygardeningmin_cleaned!=.
replace heavygardeningmin_cleaned = heavygardeningmin_cleaned-60 if heavygardeningmin_cleaned >=60 & heavygardeningmin_cleaned!=.

gen weedprunehr_cleaned = floor(weedt)
gen weedprunemin_cleaned = 100*(weedt - weedprunehr_cleaned)
replace weedprunehr_cleaned = weedprunehr_cleaned+1 if weedprunemin_cleaned >=60 & weedprunemin_cleaned!=.
replace weedprunemin_cleaned = weedprunemin_cleaned-60 if weedprunemin_cleaned >=60 & weedprunemin_cleaned!=.

gen diyhr_cleaned = floor(diyt)
gen diymin_cleaned = 100*(diyt - diyhr_cleaned)
replace diyhr_cleaned = diyhr_cleaned+1 if diymin_cleaned >=60 & diymin_cleaned!=.
replace diymin_cleaned = diymin_cleaned-60 if diymin_cleaned >=60 & diymin_cleaned!=.

gen aerobicsotherhr_cleaned = floor(aerot)
gen aerobicsothermin_cleaned = 100*(aerot - aerobicsotherhr_cleaned)
replace aerobicsotherhr_cleaned = aerobicsotherhr_cleaned+1 if aerobicsothermin_cleaned >=60 & aerobicsothermin_cleaned!=.
replace aerobicsothermin_cleaned = aerobicsothermin_cleaned-60 if aerobicsothermin_cleaned >=60 & aerobicsothermin_cleaned!=.

gen aerobicshighhr_cleaned = floor(stept)
gen aerobicshighmin_cleaned = 100*(stept - aerobicshighhr_cleaned)
replace aerobicshighhr_cleaned = aerobicshighhr_cleaned+1 if aerobicshighmin_cleaned >=60 & aerobicshighmin_cleaned!=.
replace aerobicshighmin_cleaned = aerobicshighmin_cleaned-60 if aerobicshighmin_cleaned >=60 & aerobicshighmin_cleaned!=.

gen exerciseweightshr_cleaned = floor(wghtt)
gen exerciseweightsmin_cleaned = 100*(wghtt - exerciseweightshr_cleaned)
replace exerciseweightshr_cleaned = exerciseweightshr_cleaned+1 if exerciseweightsmin_cleaned >=60 & exerciseweightsmin_cleaned!=.
replace exerciseweightsmin_cleaned = exerciseweightsmin_cleaned-60 if exerciseweightsmin_cleaned >=60 & exerciseweightsmin_cleaned!=.

gen conditionexercisehr_cleaned = floor(exert)
gen conditionexercisemin_cleaned = 100*(exert - conditionexercisehr_cleaned)
replace conditionexercisehr_cleaned = conditionexercisehr_cleaned+1 if conditionexercisemin_cleaned >=60 & conditionexercisemin_cleaned!=.
replace conditionexercisemin_cleaned = conditionexercisemin_cleaned-60 if conditionexercisemin_cleaned >=60 & conditionexercisemin_cleaned!=.

gen floorexercisehr_cleaned = floor(floort)
gen floorexercisemin_cleaned = 100*(floort - floorexercisehr_cleaned)
replace floorexercisehr_cleaned = floorexercisehr_cleaned+1 if floorexercisemin_cleaned >=60 & floorexercisemin_cleaned!=.
replace floorexercisemin_cleaned = floorexercisemin_cleaned-60 if floorexercisemin_cleaned >=60 & floorexercisemin_cleaned!=.

gen dancinghr_cleaned = floor(dancet)
gen dancingmin_cleaned = 100*(dancet - dancinghr_cleaned)
replace dancinghr_cleaned = dancinghr_cleaned+1 if dancingmin_cleaned >=60 & dancingmin_cleaned!=.
replace dancingmin_cleaned = dancingmin_cleaned-60 if dancingmin_cleaned >=60 & dancingmin_cleaned!=.

gen comprunhr_cleaned = floor(comrunt)
gen comprunmin_cleaned = 100*(comrunt - comprunhr_cleaned)
replace comprunhr_cleaned = comprunhr_cleaned+1 if comprunmin_cleaned >=60 & comprunmin_cleaned!=.
replace comprunmin_cleaned = comprunmin_cleaned-60 if comprunmin_cleaned >=60 & comprunmin_cleaned!=.

gen joghr_cleaned = floor(jogt)
gen jogmin_cleaned = 100*(jogt - joghr_cleaned)
replace joghr_cleaned = joghr_cleaned+1 if jogmin_cleaned >=60 & jogmin_cleaned!=.
replace jogmin_cleaned = jogmin_cleaned-60 if jogmin_cleaned >=60 & jogmin_cleaned!=.

gen bowlinghr_cleaned = floor(bowlt)
gen bowlingmin_cleaned = 100*(bowlt - bowlinghr_cleaned)
replace bowlinghr_cleaned = bowlinghr_cleaned+1 if bowlingmin_cleaned >=60 & bowlingmin_cleaned!=.
replace bowlingmin_cleaned = bowlingmin_cleaned-60 if bowlingmin_cleaned >=60 & bowlingmin_cleaned!=.

gen tennisbadmintonhr_cleaned = floor(tenbadt)
gen tennisbadmintonmin_cleaned = 100*(tenbadt - tennisbadmintonhr_cleaned)
replace tennisbadmintonhr_cleaned = tennisbadmintonhr_cleaned+1 if tennisbadmintonmin_cleaned >=60 & tennisbadmintonmin_cleaned!=.
replace tennisbadmintonmin_cleaned = tennisbadmintonmin_cleaned-60 if tennisbadmintonmin_cleaned >=60 & tennisbadmintonmin_cleaned!=.

gen squashhr_cleaned = floor(squasht)
gen squashmin_cleaned = 100*(squasht - squashhr_cleaned)
replace squashhr_cleaned = squashhr_cleaned+1 if squashmin_cleaned >=60 & squashmin_cleaned!=.
replace squashmin_cleaned = squashmin_cleaned-60 if squashmin_cleaned >=60 & squashmin_cleaned!=.

gen tabletennishr_cleaned = floor(tabtent)
gen tabletennismin_cleaned = 100*(tabtent - tabletennishr_cleaned)
replace tabletennishr_cleaned = tabletennishr_cleaned+1 if tabletennismin_cleaned >=60 & tabletennismin_cleaned!=.
replace tabletennismin_cleaned = tabletennismin_cleaned-60 if tabletennismin_cleaned >=60 & tabletennismin_cleaned!=.

gen golfhr_cleaned = floor(golft)
gen golfmin_cleaned = 100*(golft - golfhr_cleaned)
replace golfhr_cleaned = golfhr_cleaned+1 if golfmin_cleaned >=60 & golfmin_cleaned!=.
replace golfmin_cleaned = golfmin_cleaned-60 if golfmin_cleaned >=60 & golfmin_cleaned!=.

gen footballrugbyhockeyhr_cleaned = floor(foott)
gen footballrugbyhockeymin_cleaned = 100*(foott - footballrugbyhockeyhr_cleaned)
replace footballrugbyhockeyhr_cleaned = footballrugbyhockeyhr_cleaned+1 if footballrugbyhockeymin_cleaned >=60 & footballrugbyhockeymin_cleaned!=.
replace footballrugbyhockeymin_cleaned = footballrugbyhockeymin_cleaned-60 if footballrugbyhockeymin_cleaned >=60 & footballrugbyhockeymin_cleaned!=.

gen crickethr_cleaned = floor(crickt)
gen cricketmin_cleaned = 100*(crickt - crickethr_cleaned)
replace crickethr_cleaned = crickethr_cleaned+1 if cricketmin_cleaned >=60 & cricketmin_cleaned!=.
replace cricketmin_cleaned = cricketmin_cleaned-60 if cricketmin_cleaned >=60 & cricketmin_cleaned!=.

gen rowinghr_cleaned = floor(rowt)
gen rowingmin_cleaned = 100*(rowt - rowinghr_cleaned)
replace rowinghr_cleaned = rowinghr_cleaned+1 if rowingmin_cleaned >=60 & rowingmin_cleaned!=.
replace rowingmin_cleaned = rowingmin_cleaned-60 if rowingmin_cleaned >=60 & rowingmin_cleaned!=.

gen netvolleybasketballhr_cleaned = floor(nett)
gen netvolleybasketballmin_cleaned = 100*(nett - netvolleybasketballhr_cleaned)
replace netvolleybasketballhr_cleaned = netvolleybasketballhr_cleaned+1 if netvolleybasketballmin_cleaned >=60 & netvolleybasketballmin_cleaned!=.
replace netvolleybasketballmin_cleaned = netvolleybasketballmin_cleaned-60 if netvolleybasketballmin_cleaned >=60 & netvolleybasketballmin_cleaned!=.

gen huntingshootingfishinghr_cle = floor(fisht)
gen huntingshootingfishingmin_cle = 100*(fisht - huntingshootingfishinghr_cle)
replace huntingshootingfishinghr_cle = huntingshootingfishinghr_cle+1 if huntingshootingfishingmin_cle >=60 & huntingshootingfishingmin_cle!=.
replace huntingshootingfishingmin_cle = huntingshootingfishingmin_cle-60 if huntingshootingfishingmin_cle >=60 & huntingshootingfishingmin_cle!=.

gen horsebasedhr_cleaned = floor(horset)
gen horsebasedmin_cleaned = 100*(horset - horsebasedhr_cleaned)
replace horsebasedhr_cleaned = horsebasedhr_cleaned+1 if horsebasedmin_cleaned >=60 & horsebasedmin_cleaned!=.
replace horsebasedmin_cleaned = horsebasedmin_cleaned-60 if horsebasedmin_cleaned >=60 & horsebasedmin_cleaned!=.

gen snookerbillardsdartshr_clea = floor(snookt)
gen snookerbillardsdartsmin_clea = 100*(snookt - snookerbillardsdartshr_clea)
replace snookerbillardsdartshr_clea = snookerbillardsdartshr_clea+1 if snookerbillardsdartsmin_clea >=60 & snookerbillardsdartsmin_clea!=.
replace snookerbillardsdartsmin_clea = snookerbillardsdartsmin_clea-60 if snookerbillardsdartsmin_clea >=60 & snookerbillardsdartsmin_clea!=.

gen musicalinstrumentsinginghr_clea = floor(musict)
gen musicalinstrumentsingingmin_clea = 100*(musict - musicalinstrumentsinginghr_clea)
replace musicalinstrumentsinginghr_clea = musicalinstrumentsinginghr_clea+1 if musicalinstrumentsingingmin_clea >=60 & musicalinstrumentsingingmin_clea!=.
replace musicalinstrumentsingingmin_clea = musicalinstrumentsingingmin_clea-60 if musicalinstrumentsingingmin_clea >=60 & musicalinstrumentsingingmin_clea!=.

gen iceskatinghr_cleaned = floor(skatet)
gen iceskatingmin_cleaned = 100*(skatet - iceskatinghr_cleaned)
replace iceskatinghr_cleaned = iceskatinghr_cleaned+1 if iceskatingmin_cleaned >=60 & iceskatingmin_cleaned!=.
replace iceskatingmin_cleaned = iceskatingmin_cleaned-60 if iceskatingmin_cleaned >=60 & iceskatingmin_cleaned!=.

gen sailingwindsurfboatinghr_clea = floor(sailt)
gen sailingwindsurfboatingmin_clea = 100*(sailt - sailingwindsurfboatinghr_clea)
replace sailingwindsurfboatinghr_clea = sailingwindsurfboatinghr_clea+1 if sailingwindsurfboatingmin_clea >=60 & sailingwindsurfboatingmin_clea!=.
replace sailingwindsurfboatingmin_clea = sailingwindsurfboatingmin_clea-60 if sailingwindsurfboatingmin_clea >=60 & sailingwindsurfboatingmin_clea!=.

gen skiinghr_cleaned = floor(skit)
gen skiingmin_cleaned = 100*(skit - skiinghr_cleaned)
replace skiinghr_cleaned = skiinghr_cleaned+1 if skiingmin_cleaned >=60 & skiingmin_cleaned!=.
replace skiingmin_cleaned = skiingmin_cleaned-60 if skiingmin_cleaned >=60 & skiingmin_cleaned!=.

gen combatssportshr_cleaned = floor(boxt)
gen combatssportsmin_cleaned = 100*(boxt - combatssportshr_cleaned)
replace combatssportshr_cleaned = combatssportshr_cleaned+1 if combatssportsmin_cleaned >=60 & combatssportsmin_cleaned!=.
replace combatssportsmin_cleaned = combatssportsmin_cleaned-60 if combatssportsmin_cleaned >=60 & combatssportsmin_cleaned!=.

gen otheronehr_cleaned = floor(othonet)
gen otheronemin_cleaned = 100*(othonet - otheronehr_cleaned )

gen othertwohr_cleaned = floor(othtwot)
gen othertwomin_cleaned = 100*(othtwot - othertwohr_cleaned)
}


rename lapswif swimcomp_cleaned
rename lesswif swimleis_cleaned
rename bakpakf backpackmountainclimb_cleaned
rename walkf walkpleasure_cleaned
rename cycracf cyclingracingrough_cleaned
rename cycplef cyclepleasure_cleaned
rename lawnf mowing_cleaned
rename waterf waterlawn_cleaned
rename digf heavygardening_cleaned
rename weedf weedprune_cleaned
rename diyf diy_cleaned
rename aerof aerobicsother_cleaned
rename stepf aerobicshigh_cleaned
rename wghtf exerciseweights_cleaned
rename exerf conditionexercise_cleaned
rename floorf floorexercise_cleaned
rename dancef dancing_cleaned
rename comrunf comprun_cleaned
rename jogf jog_cleaned
rename bowlf bowling_cleaned
rename tenbadf tennisbadminton_cleaned
rename squashf squash_cleaned
rename tabtenf tabletennis_cleaned
rename golff golf_cleaned
rename footf footballrugbyhockey_cleaned
rename crickf cricket_cleaned
rename rowf rowing_cleaned
rename netf netvolleybasketball_cleaned
rename fishf huntingshootingfishing_clea
rename horsef horsebased_cleaned
rename snookf snookerbillardsdarts_clea
rename musicf musicalinstrumentsinging_clea
rename skatef iceskating_cleaned
rename sailf sailingwindsurfboating_clea
rename skif skiing_cleaned
rename boxf combatssports_cleaned



************************************************************************
/* Derivation of variables: Generate flags for missing data by domain */
************************************************************************
* MISSINGA, data on sleeping time, home activities, getting about, tv-viewing, stairclimbing
gen MISSINGA = 2
* Default is no missingness: MISSINGA=2

if version>=1 & version<=2 {
replace MISSINGA = 1 if (wkdaybed < 0 | wkdaybed == .) & (wkdayup < 0 | wkdayup == .) & (wkendbed < 0 | wkendbed == .) & (wkendup < 0 | wkendup == .) & ///
(prepfood < 1 | prepfood == .) & (shopfood < 1 | shopfood == .) & (shopelse < 1 | shopelse == .) & (cleanhse < 1 | cleanhse == .) & (laundry < 1 | laundry == .) & ///
(babycare < 1 | babycare == .) & (oldcare < 1 | oldcare == .) & (caruse < 1 | caruse == .) & (pub_tran < 1 | pub_tran == .) & (bike1 < 1 | bike1 == .) & ///
(bike2 < 1 | bike2 == .) & (bike3 < 1 | bike3 == .) & (bike4 < 1 | bike4 == .) & (bike5 < 1 | bike5 == .) & ///
(bike6 < 1 | bike6 == .) & (walk1 < 1 | walk1 == .) & (walk2 < 1 | walk2 == .) & (walk3 < 1 | walk3 == .) & ///
(walk4 < 1 | walk4 == .) & (walk5 < 1 | walk5 == .) & (walk6 < 1 | walk6 == .) & (MEDIAWEEKDAYPRE6PM < 1 | MEDIAWEEKDAYPRE6PM == .) & ///
(MEDIAWEEKDAYPOST6PM < 1 | MEDIAWEEKDAYPOST6PM == .) & (MEDIAWEEKENDDAYPRE6PM < 1 | MEDIAWEEKENDDAYPRE6PM == .) & ///
(MEDIAWEEKENDDAYPOST6PM < 1 | MEDIAWEEKENDDAYPOST6PM == .) & (STAIRCLIMBINGWEEKDAY  < 1 | STAIRCLIMBINGWEEKDAY == .) & ///
(STAIRCLIMBINGWEEKENDDAY  < 1 | STAIRCLIMBINGWEEKENDDAY == .) 
}

if version>=4 & version<=5 {
replace MISSINGA = 1 if (wkdaybed < 0 | wkdaybed == .) & (wkdayup < 0 | wkdayup == .) & (wkendbed < 0 | wkendbed == .) & (wkendup < 0 | wkendup == .) & ///
(prepfood < 1 | prepfood == .) & (shopfood < 1 | shopfood == .) & (shopelse < 1 | shopelse == .) & (cleanhse < 1 | cleanhse == .) & (laundry < 1 | laundry == .) & ///
(babycare < 1 | babycare == .) & (oldcare < 1 | oldcare == .) & (distance1 < 1 | distance1 == .) & (distance2 < 1 | distance2 == .) & (distance3 < 1 | distance3 == .) & (MEDIAWEEKDAYPRE6PM < 1 | MEDIAWEEKDAYPRE6PM == .) & ///
(MEDIAWEEKDAYPOST6PM < 1 | MEDIAWEEKDAYPOST6PM == .) & (MEDIAWEEKENDDAYPRE6PM < 1 | MEDIAWEEKENDDAYPRE6PM == .) & ///
(MEDIAWEEKENDDAYPOST6PM < 1 | MEDIAWEEKENDDAYPOST6PM == .) & (STAIRCLIMBINGWEEKDAY  < 1 | STAIRCLIMBINGWEEKDAY == .) & ///
(STAIRCLIMBINGWEEKENDDAY  < 1 | STAIRCLIMBINGWEEKENDDAY == .) 
}

* If all data is missing, then MISSINGA=1


/* MISSINGJOB AND EMPLOYED */
gen MISSINGJOB = 2
* Default is no missingness: MISSINGJOB=2 */

if version>=1 & version<=2 {
replace MISSINGJOB = 1 if (sitaone < 1 | sitaone == .) & (sitbone < 1 | sitbone  == .) & (sitbone < 1 | sitbone  == .) & (staaone < 1 | staaone  == .) & ///
(stabone < 1 | stabone  == .) & (stacone < 1 | stacone == .) & (stadone < 1 | stadone == .) & (walaone < 1 | walaone == .) & (walbone < 1 | walbone == .) & ///
(movone < 1 | movone == .) & (sitaoneh < 1 | sitaoneh == .) & (sitboneh < 1 | sitboneh  == .) & (sitboneh < 1 | sitboneh  == .) & (staaoneh < 1 | staaoneh  == .) & ///
(staboneh < 1 | staboneh  == .) & (staconeh < 1 | staconeh == .) & (stadoneh < 1 | stadoneh == .) & (walaoneh < 1 | walaoneh == .) & (walboneh < 1 | walboneh == .) & ///
(movoneh < 1 | movoneh == .) & (sitatwo < 1 | sitatwo == .) & (sitbtwo < 1 | sitbtwo  == .) & (sitbtwo < 1 | sitbtwo  == .) & (staatwo < 1 | staatwo  == .) & ///
(stabtwo < 1 | stabtwo  == .) & (stactwo < 1 | stactwo == .) & (stadtwo < 1 | stadtwo == .) & (walatwo < 1 | walatwo == .) & (walbtwo < 1 | walbtwo == .) & ///
(movtwo < 1 | movtwo == .) & (sitatwoh < 1 | sitatwoh == .) & (sitbtwoh < 1 | sitbtwoh  == .) & (sitbtwoh < 1 | sitbtwoh  == .) & (staatwoh < 1 | staatwoh  == .) & ///
(stabtwoh < 1 | stabtwoh  == .) & (stactwoh < 1 | stactwoh == .) & (stadtwoh < 1 | stadtwoh == .) & (walatwoh < 1 | walatwoh == .) & (walbtwoh < 1 | walbtwoh == .) & ///
(movtwoh < 1 | movtwoh == .) & (sitathr < 1 | sitathr == .) & (sitbthr < 1 | sitbthr == .) & (sitbthr < 1 | sitbthr == .) & (staathr < 1 | staathr  == .) & ///
(stabthr < 1 | stabthr  == .) & (stacthr < 1 | stacthr == .) & (stadthr < 1 | stadthr == .) & (walathr < 1 | walathr == .) & (walbthr < 1 | walbthr == .) & ///
(movthr < 1 | movthr == .) & (sitathrh < 1 | sitathrh == .) & (sitbthrh < 1 | sitbthrh  == .) & (sitbthrh < 1 | sitbthrh  == .) & (staathrh < 1 | staathrh  == .) & ///
(stabthrh < 1 | stabthrh  == .) & (stacthrh < 1 | stacthrh == .) & (stadthrh < 1 | stadthrh == .) & (walathrh < 1 | walathrh == .) & (walbthrh < 1 | walbthrh == .) & ///
(movthrh < 1 | movthrh == .) & (stairone < 1 | stairone == .) & (laddone < 1 | laddone == .) & (stairtwo < 1 | stairtwo == .) & (laddtwo < 1 | laddtwo == .) & ///
(stairthr < 1 | stairthr == .) & (laddthr < 1 | laddthr == .) & (kneel < 1 | kneel == .) & (squat < 1 | squat == .) & (get_up < 1 | get_up == .) 
}

if version>=4 & version<=5 {
replace MISSINGJOB = 1 if (sitaone < 1 | sitaone == .) & (sitbone < 1 | sitbone  == .) & (sitbone < 1 | sitbone  == .) & (staaone < 1 | staaone  == .) & ///
(stabone < 1 | stabone  == .) & (stacone < 1 | stacone == .) & (stadone < 1 | stadone == .) & (walaone < 1 | walaone == .) & (walbone < 1 | walbone == .) & ///
(movone < 1 | movone == .) & (sitaoneh < 1 | sitaoneh == .) & (sitboneh < 1 | sitboneh  == .) & (sitboneh < 1 | sitboneh  == .) & (staaoneh < 1 | staaoneh  == .) & ///
(staboneh < 1 | staboneh  == .) & (staconeh < 1 | staconeh == .) & (stadoneh < 1 | stadoneh == .) & (walaoneh < 1 | walaoneh == .) & (walboneh < 1 | walboneh == .) & ///
(movoneh < 1 | movoneh == .) & (sitatwo < 1 | sitatwo == .) & (sitbtwo < 1 | sitbtwo  == .) & (sitbtwo < 1 | sitbtwo  == .) & (staatwo < 1 | staatwo  == .) & ///
(stabtwo < 1 | stabtwo  == .) & (stactwo < 1 | stactwo == .) & (stadtwo < 1 | stadtwo == .) & (walatwo < 1 | walatwo == .) & (walbtwo < 1 | walbtwo == .) & ///
(movtwo < 1 | movtwo == .) & (sitatwoh < 1 | sitatwoh == .) & (sitbtwoh < 1 | sitbtwoh  == .) & (sitbtwoh < 1 | sitbtwoh  == .) & (staatwoh < 1 | staatwoh  == .) & ///
(stabtwoh < 1 | stabtwoh  == .) & (stactwoh < 1 | stactwoh == .) & (stadtwoh < 1 | stadtwoh == .) & (walatwoh < 1 | walatwoh == .) & (walbtwoh < 1 | walbtwoh == .) & ///
(movtwoh < 1 | movtwoh == .) & (j1stairs < 1 | j1stairs == .) & (j1ladder < 1 | j1ladder == .) & (j2stairs < 1 | j2stairs == .) & (j2ladder < 1 | j2ladder == .) & ///
(j1kneel < 1 | j1kneel == .) & (j1squat < 1 | j1squat == .) & (j1getup < 1 | j1getup == .) & (j2kneel < 1 | j2kneel == .) & (j2squat < 1 | j2squat == .) & (j2getup < 1 | j2getup == .)
}

gen MISSINGJOB1 = 2
if version>=1 & version<=2 {
replace MISSINGJOB1 = 1 if (sitaone < 1 | sitaone == .) & (sitbone < 1 | sitbone  == .) & (sitbone < 1 | sitbone  == .) & (staaone < 1 | staaone  == .) & ///
(stabone < 1 | stabone  == .) & (stacone < 1 | stacone == .) & (stadone < 1 | stadone == .) & (walaone < 1 | walaone == .) & (walbone < 1 | walbone == .) & ///
(movone < 1 | movone == .) & (sitaoneh < 1 | sitaoneh == .) & (sitboneh < 1 | sitboneh  == .) & (sitboneh < 1 | sitboneh  == .) & (staaoneh < 1 | staaoneh  == .) & ///
(staboneh < 1 | staboneh  == .) & (staconeh < 1 | staconeh == .) & (stadoneh < 1 | stadoneh == .) & (walaoneh < 1 | walaoneh == .) & (walboneh < 1 | walboneh == .) & ///
(movoneh < 1 | movoneh == .) & (stairone < 1 | stairone == .) & (laddone < 1 | laddone == .)  
}

if version>=4 & version<=5 {
replace MISSINGJOB1 = 1 if (sitaone < 1 | sitaone == .) & (sitbone < 1 | sitbone  == .) & (sitbone < 1 | sitbone  == .) & (staaone < 1 | staaone  == .) & ///
(stabone < 1 | stabone  == .) & (stacone < 1 | stacone == .) & (stadone < 1 | stadone == .) & (walaone < 1 | walaone == .) & (walbone < 1 | walbone == .) & ///
(movone < 1 | movone == .) & (sitaoneh < 1 | sitaoneh == .) & (sitboneh < 1 | sitboneh  == .) & (sitboneh < 1 | sitboneh  == .) & (staaoneh < 1 | staaoneh  == .) & ///
(staboneh < 1 | staboneh  == .) & (staconeh < 1 | staconeh == .) & (stadoneh < 1 | stadoneh == .) & (walaoneh < 1 | walaoneh == .) & (walboneh < 1 | walboneh == .) & ///
(movoneh < 1 | movoneh == .) & (j1stairs < 1 | j1stairs == .) & (j1ladder < 1 | j1ladder == .) & (j1kneel < 1 | j1kneel == .) & (j1squat < 1 | j1squat == .) & (j1getup < 1 | j1getup == .) 
}

gen MISSINGJOB2 = 2
if version>=1 & version<=2 {
replace MISSINGJOB2 = 1 if (sitatwo < 1 | sitatwo == .) & (sitbtwo < 1 | sitbtwo  == .) & (sitbtwo < 1 | sitbtwo  == .) & (staatwo < 1 | staatwo  == .) & ///
(stabtwo < 1 | stabtwo  == .) & (stactwo < 1 | stactwo == .) & (stadtwo < 1 | stadtwo == .) & (walatwo < 1 | walatwo == .) & (walbtwo < 1 | walbtwo == .) & ///
(movtwo < 1 | movtwo == .) & (sitatwoh < 1 | sitatwoh == .) & (sitbtwoh < 1 | sitbtwoh  == .) & (sitbtwoh < 1 | sitbtwoh  == .) & (staatwoh < 1 | staatwoh  == .) & ///
(stabtwoh < 1 | stabtwoh  == .) & (stactwoh < 1 | stactwoh == .) & (stadtwoh < 1 | stadtwoh == .) & (walatwoh < 1 | walatwoh == .) & (walbtwoh < 1 | walbtwoh == .) & ///
(movtwoh < 1 | movtwoh == .) & (stairtwo < 1 | stairtwo == .) & (laddtwo < 1 | laddtwo == .) 
}

if version>=4 & version<=5 {
replace MISSINGJOB2 = 1 if (sitatwo < 1 | sitatwo == .) & (sitbtwo < 1 | sitbtwo  == .) & (sitbtwo < 1 | sitbtwo  == .) & (staatwo < 1 | staatwo  == .) & ///
(stabtwo < 1 | stabtwo  == .) & (stactwo < 1 | stactwo == .) & (stadtwo < 1 | stadtwo == .) & (walatwo < 1 | walatwo == .) & (walbtwo < 1 | walbtwo == .) & ///
(movtwo < 1 | movtwo == .) & (sitatwoh < 1 | sitatwoh == .) & (sitbtwoh < 1 | sitbtwoh  == .) & (sitbtwoh < 1 | sitbtwoh  == .) & (staatwoh < 1 | staatwoh  == .) & ///
(stabtwoh < 1 | stabtwoh  == .) & (stactwoh < 1 | stactwoh == .) & (stadtwoh < 1 | stadtwoh == .) & (walatwoh < 1 | walatwoh == .) & (walbtwoh < 1 | walbtwoh == .) & ///
(movtwoh < 1 | movtwoh == .) & (j2stairs < 1 | j2stairs == .) & (j2ladder < 1 | j2ladder == .) & ///
(j2kneel < 1 | j2kneel == .) & (j2squat < 1 | j2squat == .) & (j2getup < 1 | j2getup == .)
}


/* Commented out calculation of EMPLOYED, not used in the rest of the code
gen EMPLOYED = .
replace EMPLOYED = 2 if job_now2 == 2 
replace EMPLOYED = 1 if job_now2 == 1 | MISSINGJOB == 2
* EMPLOYED = 1 if they are in employment and data is not missing
*/

replace sitaone=2 if (sitaoneh>0) & (sitaoneh<.)
replace sitbone=2 if (sitboneh>0) & (sitboneh<.)
replace staaone=2 if (staaoneh>0) & (staaoneh<.)
replace stabone=2 if (staboneh>0) & (staboneh<.)
replace stacone=2 if (staconeh>0) & (staconeh<.)
replace stadone=2 if (stadoneh>0) & (stadoneh<.)
replace walaone=2 if (walaoneh>0) & (walaoneh<.)
replace walbone=2 if (walboneh>0) & (walboneh<.)
replace movone=2 if (movoneh>0) & (movoneh<.)

replace sitatwo=2 if (sitatwoh>0) & (sitatwoh<.)
replace sitbtwo=2 if (sitbtwoh>0) & (sitbtwoh<.)
replace staatwo=2 if (staatwoh>0) & (staatwoh<.)
replace stabtwo=2 if (stabtwoh>0) & (stabtwoh<.)
replace stactwo=2 if (stactwoh>0) & (stactwoh<.)
replace stadtwo=2 if (stadtwoh>0) & (stadtwoh<.)
replace walatwo=2 if (walatwoh>0) & (walatwoh<.)
replace walbtwo=2 if (walbtwoh>0) & (walbtwoh<.)
replace movtwo=2 if (movtwoh>0) & (movtwoh<.)


/* MISSINGCOMMUT */
gen MISSINGCOMMUT = 2
* Default is no missingness: MISSINGJOB=2 */


if version>=1 & version<=2 {
replace MISSINGCOMMUT = 1 if (carone < 1 | carone == .) & (pubone < 1 | pubone == .) & (bikone < 1 | bikone == .) & (walone < 1 | walone == .) & ///
(cartwo < 1 | cartwo == .) & (pubtwo < 1 | pubtwo == .) & (biktwo < 1 | biktwo == .) & (waltwo < 1 | waltwo == .) ///
 & (commutenoone_cleaned < 0 | commutenoone_cleaned == .) & ///
(commutenotwo_cleaned < 0 | commutenotwo_cleaned == .) & (wrkmiles_cleaned1 < 0 | wrkmiles_cleaned1 == .) & ///
(wrkmiles_cleaned2 < 0 | wrkmiles_cleaned2 == .) & (carthr < 1 | carthr == .) & (pubthr < 1 | pubthr == .) & ///
(bikthr < 1 | bikthr == .) & (walthr < 1 | walthr == .) & (commutenothr_cleaned < 0 | commutenothr_cleaned == .) ///
& (wrkmiles_cleaned3 < 0 | wrkmiles_cleaned3 == .)
}

if version>=4 & version<=5 {
replace MISSINGCOMMUT = 1 if (carone < 1 | carone == .) & (pubone < 1 | pubone == .) & (bikone < 1 | bikone == .) & (walone < 1 | walone == .) & ///
(cartwo < 1 | cartwo == .) & (pubtwo < 1 | pubtwo == .) & (biktwo < 1 | biktwo == .) & (waltwo < 1 | waltwo == .) ///
 & (commutenoone_cleaned < 0 | commutenoone_cleaned == .) & ///
(commutenotwo_cleaned < 0 | commutenotwo_cleaned == .) & (wrkmiles_cleaned1 < 0 | wrkmiles_cleaned1 == .) & ///
(wrkmiles_cleaned2 < 0 | wrkmiles_cleaned2 == .) 
}


***************************************************
/* MISSINGC: Missing data in leisure time domain */
***************************************************
gen MISSINGC = 2
replace MISSINGC = 1 if ///
(swimcomp_cleaned < 1 | swimcomp_cleaned==.) & (swimcomphr_cleaned < 0 | swimcomphr_cleaned==.) & (swimcompmin_cleaned < 0 | swimcompmin_cleaned==.) & ///
(swimleis_cleaned < 1 | swimleis_cleaned==.) & (swimleishr_cleaned < 0 | swimleishr_cleaned==.) & (swimleismin_cleaned < 0 | swimleismin_cleaned==.) & ///
(backpackmountainclimb_cleaned < 1 | backpackmountainclimb_cleaned==.) & (backpackmountainclimbhr_cleaned < 0 | backpackmountainclimbhr_cleaned==.) & (backpackmountainclimbmin_cleaned < 0 | backpackmountainclimbmin_cleaned==.) & ///
(walkpleasure_cleaned < 1 | walkpleasure_cleaned==.) & (walkpleasurehr_cleaned < 0 | walkpleasurehr_cleaned==.) & (walkpleasuremin_cleaned < 0 | walkpleasuremin_cleaned==.) & ///
(cyclingracingrough_cleaned < 1 | cyclingracingrough_cleaned==.) & (cyclingracingroughhr_cleaned < 0 | cyclingracingroughhr_cleaned==.) & (cyclingracingroughmin_cleaned < 0 | cyclingracingroughmin_cleaned==.) & ///
(cyclepleasure_cleaned < 1 | cyclepleasure_cleaned==.) & (cyclepleasurehr_cleaned < 0 | cyclepleasurehr_cleaned==.) & (cyclepleasuremin_cleaned < 0 | cyclepleasuremin_cleaned==.) & ///
(mowing_cleaned < 1 | mowing_cleaned==.) & (mowinghr_cleaned < 0 | mowinghr_cleaned==.) & (mowingmin_cleaned < 0 | mowingmin_cleaned==.) & ///
(waterlawn_cleaned < 1 | waterlawn_cleaned==.) & (waterlawnhr_cleaned < 0 | waterlawnhr_cleaned==.) & (waterlawnmin_cleaned < 0 | waterlawnmin_cleaned==.) & ///
(heavygardening_cleaned < 1 | heavygardening_cleaned==.) & (heavygardeninghr_cleaned < 0 | heavygardeninghr_cleaned==.) & (heavygardeningmin_cleaned < 0 | heavygardeningmin_cleaned==.) & ///
(weedprune_cleaned < 1 | weedprune_cleaned==.) & (weedprunehr_cleaned < 0 | weedprunehr_cleaned==.) & (weedprunemin_cleaned < 0 | weedprunemin_cleaned==.) & ///
(diy_cleaned < 1 | diy_cleaned==.) & (diyhr_cleaned < 0 | diyhr_cleaned==.) & (diymin_cleaned < 0 | diymin_cleaned==.) & ///
(aerobicshigh_cleaned < 1 | aerobicshigh_cleaned==.) & (aerobicshighhr_cleaned < 0 | aerobicshighhr_cleaned==.) & (aerobicshighmin_cleaned < 0 | aerobicshighmin_cleaned==.) & ///
(aerobicsother_cleaned < 1 | aerobicsother_cleaned==.) & (aerobicsotherhr_cleaned < 0 | aerobicsotherhr_cleaned==.) & (aerobicsothermin_cleaned < 0 | aerobicsothermin_cleaned==.) & ///
(exerciseweights_cleaned < 1 | exerciseweights_cleaned==.) & (exerciseweightshr_cleaned < 0 | exerciseweightshr_cleaned==.) & (exerciseweightsmin_cleaned < 0 | exerciseweightsmin_cleaned==.) & ///
(conditionexercise_cleaned < 1 | conditionexercise_cleaned==.) & (conditionexercisehr_cleaned < 0 | conditionexercisehr_cleaned==.) & (conditionexercisemin_cleaned < 0 | conditionexercisemin_cleaned==.) & ///
(floorexercise_cleaned < 1 | floorexercise_cleaned==.) & (floorexercisehr_cleaned < 0 | floorexercisehr_cleaned==.) & (floorexercisemin_cleaned < 0 | floorexercisemin_cleaned==.) & ///
(dancing_cleaned < 1 | dancing_cleaned==.) & (dancinghr_cleaned < 0 | dancinghr_cleaned==.) & (dancingmin_cleaned < 0 | dancingmin_cleaned==.) & ///
(comprun_cleaned < 1 | comprun_cleaned==.) & (comprunhr_cleaned < 0 | comprunhr_cleaned==.) & (comprunmin_cleaned < 0 | comprunmin_cleaned==.) & ///
(jog_cleaned < 1 | jog_cleaned==.) & (joghr_cleaned < 0 | joghr_cleaned==.) & (jogmin_cleaned < 0 | jogmin_cleaned==.) & ///
(bowling_cleaned < 1 | bowling_cleaned==.) & (bowlinghr_cleaned < 0 | bowlinghr_cleaned==.) & (bowlingmin_cleaned < 0 | bowlingmin_cleaned==.) & ///
(tennisbadminton_cleaned < 1 | tennisbadminton_cleaned==.) & (tennisbadmintonhr_cleaned < 0 | tennisbadmintonhr_cleaned==.) & (tennisbadmintonmin_cleaned < 0 | tennisbadmintonmin_cleaned==.) & ///
(squash_cleaned < 1 | squash_cleaned==.) & (squashhr_cleaned < 0 | squashhr_cleaned==.) & (squashmin_cleaned < 0 | squashmin_cleaned==.) & ///
(tabletennis_cleaned < 1 | tabletennis_cleaned==.) & (tabletennishr_cleaned < 0 | tabletennishr_cleaned==.) & (tabletennismin_cleaned < 0 | tabletennismin_cleaned==.) & ///
(golf_cleaned < 1 | golf_cleaned==.) & (golfhr_cleaned < 0 | golfhr_cleaned==.) & (golfmin_cleaned < 0 | golfmin_cleaned==.) & ///
(footballrugbyhockey_cleaned < 1 | footballrugbyhockey_cleaned==.) & (footballrugbyhockeyhr_cleaned < 0 | footballrugbyhockeyhr_cleaned==.) & (footballrugbyhockeymin_cleaned < 0 | footballrugbyhockeymin_cleaned==.) & ///
(cricket_cleaned < 1 | cricket_cleaned==.) & (crickethr_cleaned < 0 | crickethr_cleaned==.) & (cricketmin_cleaned < 0 | cricketmin_cleaned==.) & (rowing_cleaned < 1 | rowing_cleaned==.) & (rowinghr_cleaned < 0 | rowinghr_cleaned==.) & (rowingmin_cleaned < 0 | rowingmin_cleaned==.) & ///
(rowing_cleaned < 1 | rowing_cleaned==.) & (rowinghr_cleaned < 0 | rowinghr_cleaned==.) & (rowingmin_cleaned < 0 | rowingmin_cleaned==.) & ///
(netvolleybasketball_cleaned < 1 | netvolleybasketball_cleaned==.) & (netvolleybasketballhr_cleaned < 0 | netvolleybasketballhr_cleaned==.) & (netvolleybasketballmin_cleaned < 0 | netvolleybasketballmin_cleaned==.) & ///
(huntingshootingfishing_c < 1 | huntingshootingfishing_c==.) & (huntingshootingfishinghr_c < 0 | huntingshootingfishinghr_c==.) & (huntingshootingfishingmin_c < 0 | huntingshootingfishingmin_c==.) & (horsebased_cleaned < 1 | horsebased_cleaned==.) & (horsebasedhr_cleaned < 0 | horsebasedhr_cleaned==.) & (horsebasedmin_cleaned < 0 | horsebasedmin_cleaned==.) & ///
(horsebased_cleaned < 1 | horsebased_cleaned==.) & (horsebasedhr_cleaned < 0 | horsebasedhr_cleaned==.) & (horsebasedmin_cleaned < 0 | horsebasedmin_cleaned==.) & ///
(snookerbillardsdarts_c < 1 | snookerbillardsdarts_c==.) & (snookerbillardsdartshr_c < 0 | snookerbillardsdartshr_c==.) & (snookerbillardsdartsmin_c < 0 | snookerbillardsdartsmin_c==.) & ///
(musicalinstrumentsinging_c < 1 | musicalinstrumentsinging_c==.) & (musicalinstrumentsinginghr_c < 0 | musicalinstrumentsinginghr_c==.) & (musicalinstrumentsingingmin_c < 0 | musicalinstrumentsingingmin_c==.) & ///
(iceskating_cleaned < 1 | iceskating_cleaned==.) & (iceskatinghr_cleaned < 0 | iceskatinghr_cleaned==.) & (iceskatingmin_cleaned < 0 | iceskatingmin_cleaned==.) & ///
(sailingwindsurfboating_c < 1 | sailingwindsurfboating_c==.) & (sailingwindsurfboatinghr_c < 0 | sailingwindsurfboatinghr_c==.) & (sailingwindsurfboatingmin_c < 0 | sailingwindsurfboatingmin_c==.) & ///
(skiing_cleaned < 1 | skiing_cleaned==.) & (skiinghr_cleaned < 0 | skiinghr_cleaned==.) & (skiingmin_cleaned < 0 | skiingmin_cleaned==.)  & ///
(combatssports_cleaned < 1 | combatssports_cleaned==.) & (combatssportshr_cleaned < 0 | combatssportshr_cleaned==.) & (combatssportsmin_cleaned < 0 | combatssportsmin_cleaned==.) 

*Note that some of the variable names have been truncated above - this is because Stata limits variable names, but the above code runs correctly. 

/* Count number of leisure activities with no data at all, create variable leisure_missing_all_data */

gen leisure_missing_all_data=0
gen activities_done=0

foreach x in swimcomp swimleis backpackmountainclimb  walkpleasure cyclingracingrough cyclepleasure mowing waterlawn heavygardening ///
weedprune diy aerobicshigh aerobicsother exerciseweights conditionexercise floorexercise dancing comprun jog bowling tennisbadminton ///
squash tabletennis golf footballrugbyhockey cricket rowing netvolleybasketball huntingshootingfishing horsebased snookerbillardsdarts ///
musicalinstrumentsinging iceskating sailingwindsurfboating skiing combatssports {
	
	replace leisure_missing_all_data = leisure_missing_all_data + 1 if `x'_cle==. & `x'hr_cle==. & `x'min_cle==.
	replace activities_done = activities_done + 1 if (`x'_cle!=. & `x'_cle!=1) | (`x'hr_cle!=. & `x'hr_cle!=0) | (`x'min_cle!=. & `x'min_cle!=0)
}

/* Count number of leisure activities with no frequency indicated, create variable leisure_missing_freq */

gen leisure_missing_freq=0

foreach x in swimcomp swimleis backpackmountainclimb  walkpleasure cyclingracingrough cyclepleasure mowing waterlawn heavygardening ///
weedprune diy aerobicshigh aerobicsother exerciseweights conditionexercise floorexercise dancing comprun jog bowling tennisbadminton ///
squash tabletennis golf footballrugbyhockey cricket rowing netvolleybasketball huntingshootingfishing horsebased snookerbillardsdarts ///
musicalinstrumentsinging iceskating sailingwindsurfboating skiing combatssports {
	
	replace leisure_missing_freq = leisure_missing_freq + 1 if `x'_cle==. & (`x'hr_cle!=. | `x'min_cle!=.) 
}

/* Count number of leisure activities with no duration, create variable leisure_missing_duration */

gen leisure_missing_duration=0

foreach x in swimcomp swimleis backpackmountainclimb  walkpleasure cyclingracingrough cyclepleasure mowing waterlawn heavygardening ///
weedprune diy aerobicshigh aerobicsother exerciseweights conditionexercise floorexercise dancing comprun jog bowling tennisbadminton ///
squash tabletennis golf footballrugbyhockey cricket rowing netvolleybasketball huntingshootingfishing horsebased snookerbillardsdarts ///
musicalinstrumentsinging iceskating sailingwindsurfboating skiing combatssports {
	
	replace leisure_missing_duration = leisure_missing_duration + 1 if `x'hr_cle==. & `x'min_cle==. & `x'_cle!=1 & `x'_cle!=.
	* it's OK for duration to be missing if they have said they don't do the activity
}


/* MISSING - all domains*/
gen MISSING = 2
replace MISSING = 1 if MISSINGA == 1 & MISSINGJOB == 1 & MISSINGCOMMUT == 1 & MISSINGC == 1

*SLEEP
*assumes data are entered as hhmm

replace wkdayup = wkdayup*10 if wkdayup>59 & wkdayup<100
replace wkendup = wkendup*10 if wkendup>59 & wkendup<100


gen WKDAYBEDhr = floor(wkdaybed/100)
gen WKDAYBEDmin= wkdaybed - WKDAYBEDhr*100
gen WKDAYBEDtime = WKDAYBEDhr+WKDAYBEDmin/60

gen WKDAYUPhr = floor(wkdayup/100)
gen WKDAYUPmin= wkdayup - WKDAYUPhr*100
gen WKDAYUPtime = WKDAYUPhr+WKDAYUPmin/60

gen WKENDDAYBEDhr = floor(wkendbed/100)
gen WKENDDAYBEDmin= wkendbed - WKENDDAYBEDhr*100
gen WKENDDAYBEDtime = WKENDDAYBEDhr+WKENDDAYBEDmin/60

gen WKENDDAYUPhr = floor(wkendup/100)
gen WKENDDAYUPmin= wkendup - WKENDDAYUPhr*100
gen WKENDDAYUPtime = WKENDDAYUPhr+WKENDDAYUPmin/60

gen WKDAYSLEEP = .
gen WKENDDAYSLEEP = .


replace WKDAYSLEEP = WKDAYUPtime - WKDAYBEDtime if ((WKDAYBEDtime >= 12 & WKDAYBEDtime!=. & WKDAYUPtime >= 12 & WKDAYUPtime!=.) | (WKDAYBEDtime < 12 & WKDAYUPtime < 12)) & (WKDAYBEDtime <= WKDAYUPtime)
replace WKDAYSLEEP =  24 - WKDAYBEDtime + WKDAYUPtime if ((WKDAYBEDtime >= 12 & WKDAYBEDtime!=. & WKDAYUPtime >= 12 & WKDAYUPtime!=.) | (WKDAYBEDtime < 12 & WKDAYUPtime < 12)) & (WKDAYBEDtime > WKDAYUPtime)
replace WKDAYSLEEP = WKDAYUPtime - WKDAYBEDtime if WKDAYBEDtime < 12 & WKDAYUPtime >= 12  & WKDAYUPtime!=. 
replace WKDAYSLEEP = 24 - WKDAYBEDtime + WKDAYUPtime if WKDAYBEDtime >= 12 & WKDAYBEDtime!=. & WKDAYUPtime < 12  

replace WKENDDAYSLEEP = WKENDDAYUPtime - WKENDDAYBEDtime if ((WKENDDAYBEDtime >= 12 & WKENDDAYBEDtime!=. & WKENDDAYUPtime >= 12 & WKENDDAYUPtime!=.) | (WKENDDAYBEDtime < 12 & WKENDDAYUPtime < 12)) & (WKENDDAYBEDtime <= WKENDDAYUPtime)
replace WKENDDAYSLEEP =  24 - WKENDDAYBEDtime + WKENDDAYUPtime if ((WKENDDAYBEDtime >= 12 & WKENDDAYBEDtime!=. & WKENDDAYUPtime >= 12 & WKENDDAYUPtime!=.) | (WKENDDAYBEDtime < 12 & WKENDDAYUPtime < 12)) & (WKENDDAYBEDtime > WKENDDAYUPtime)
replace WKENDDAYSLEEP = WKENDDAYUPtime - WKENDDAYBEDtime if WKENDDAYBEDtime < 12 & WKENDDAYUPtime >= 12  & WKENDDAYUPtime!=. 
replace WKENDDAYSLEEP = 24 - WKENDDAYBEDtime + WKENDDAYUPtime if WKENDDAYBEDtime >= 12 & WKENDDAYBEDtime!=. & WKENDDAYUPtime < 12  


replace WKDAYSLEEP = . if WKDAYSLEEP <3 | WKDAYSLEEP >14 & WKDAYSLEEP !=.
replace WKENDDAYSLEEP = . if WKENDDAYSLEEP <3 | WKENDDAYSLEEP >15 & WKDAYSLEEP !=.

gen DURSLEEP = (5*WKDAYSLEEP + 2*WKENDDAYSLEEP)/7 if MISSINGA==2
su DURSLEEP, d
replace DURSLEEP = r(p50) if DURSLEEP ==.

/* CALCULATION OF DAILY DURATIONS */

/* These variables are not currently used later in the script, they are here as placeholders
rename caruse GETABOUT_caruse
rename pub_tran GETABOUT_pubtranuse
*/

gen GETABOUT_bikedist = .
gen GETABOUT_walkdist = .

*replace GETABOUT_bikedist = 0 if MISSINGA==1

if version>=1 & version<=2 {
 replace GETABOUT_bikedist = 0.25*bike1 + 1*bike2 + 2*bike3 + 3*bike4 + 4.5*bike5 + 6*bike6 if MISSINGA==2 
 replace GETABOUT_walkdist = 0.25*walk1 + 1*walk2 + 2*walk3 + 3*walk4 + 4.5*walk5 + 6*walk6 if MISSINGA==2 
	}
	

if version>=4 & version<=5 {
	*journey frequencies are hard-coded from combinations of medians from EPIC HC2 in individuals who report no motorised getting about
	* so for example, for bike_1 (bike journeys of <1 mile) we take 3 trips of 0.25 miles (median 3 trips in category <0.5 miles, assumed mean distance 0.25 miles)
	* plus 3 trips of 1 mile (median 3 trips in category 0.5-1.5 miles, assumed mean distance 1 mile) but as this category from v1/2 overlaps with the v4/5 categories
	* we weight it as 0.5*, the other 0.5*  goes into the bike_2 category, etc.
	gen bike_1 = 3*.25+0.5*3*1 if distance1==4
	gen bike_2 = 0.5*3*1+3*2+3*3+.75*4*4.5 if distance2==4
	gen bike_3 = 0.25*4*4.5+2*6 if distance3==4
	gen walk_1 = 5*.25+0.5*4*1 if distance1==2
	gen walk_2 = 0.5*4*1+3*2+2*3+.75*2*4.5 if distance2==2
	gen walk_3 = 0.25*2*4.5+2*6 if distance3==2
	
	egen temp1 = rsum(bike_1 bike_2 bike_3)
	egen temp2 = rsum(walk_1 walk_2 walk_3)

	replace GETABOUT_bikedist = temp1 if MISSINGA==2 
	replace GETABOUT_walkdist = temp2 if MISSINGA==2 
	
	drop temp1 temp2
	}


gen DURGETABOUT_BIKE = (GETABOUT_bikedist / 10) / 7
gen DURGETABOUT_WALK = (GETABOUT_walkdist / 3.0) / 7

egen DURGETABOUT = rowtotal(DURGETABOUT_BIKE DURGETABOUT_WALK)

gen GETABOUT = .
replace GETABOUT = 0 if MISSINGA == 2
replace GETABOUT = . if MISSINGA == 1

/* ASSIGN THE MEDIAN FOR TV WHEN MISSING */
gen TVDUR1 = . if MEDIAWEEKDAYPRE6PM == . & MISSINGA == 1 /* 'Not completed''*/
replace TVDUR1 = 2.5 if MEDIAWEEKDAYPRE6PM == . & MISSINGA == 2 /* 'Not completed, impute median''*/
replace TVDUR1 = 0 if MEDIAWEEKDAYPRE6PM == 1
replace TVDUR1 = 2.5 if MEDIAWEEKDAYPRE6PM == 2
replace TVDUR1 = 7.5 if MEDIAWEEKDAYPRE6PM == 3
replace TVDUR1 = 12.5 if MEDIAWEEKDAYPRE6PM == 4
replace TVDUR1 = 17.5 if MEDIAWEEKDAYPRE6PM == 5
replace TVDUR1 = 22.5 if MEDIAWEEKDAYPRE6PM == 6
gen TVDUR2 = . if MEDIAWEEKDAYPOST6PM == . & MISSINGA == 1 /* 'Not completed'*/
replace TVDUR2 = 12.5 if MEDIAWEEKDAYPOST6PM == .& MISSINGA == 2 /* 'Not completed, impute median'*/
replace TVDUR2 = 0 if MEDIAWEEKDAYPOST6PM == 1
replace TVDUR2 = 2.5 if MEDIAWEEKDAYPOST6PM == 2
replace TVDUR2 = 7.5 if MEDIAWEEKDAYPOST6PM == 3
replace TVDUR2 = 12.5 if MEDIAWEEKDAYPOST6PM == 4
replace TVDUR2 = 17.5 if MEDIAWEEKDAYPOST6PM == 5
replace TVDUR2 = 22.5 if MEDIAWEEKDAYPOST6PM == 6
gen TVDUR3 = . if MEDIAWEEKENDDAYPRE6PM == . & MISSINGA == 1 /* 'Not completed'*/
replace TVDUR3 = 1 if MEDIAWEEKENDDAYPRE6PM == . & MISSINGA == 2 /* 'Not completed, impute median'*/
replace TVDUR3 = 0 if MEDIAWEEKENDDAYPRE6PM == 1
replace TVDUR3 = 1 if MEDIAWEEKENDDAYPRE6PM == 2
replace TVDUR3 = 3 if MEDIAWEEKENDDAYPRE6PM == 3
replace TVDUR3 = 5 if MEDIAWEEKENDDAYPRE6PM == 4
replace TVDUR3 = 7 if MEDIAWEEKENDDAYPRE6PM == 5
replace TVDUR3 = 9 if MEDIAWEEKENDDAYPRE6PM == 6
gen TVDUR4 = . if MEDIAWEEKENDDAYPOST6P == . & MISSINGA == 1 /* 'Not completed'*/
replace TVDUR4 = 3 if MEDIAWEEKENDDAYPOST6PM == . & MISSINGA == 2 /* 'Not completed, impute median'*/
replace TVDUR4 = 0 if MEDIAWEEKENDDAYPOST6PM == 1
replace TVDUR4 = 1 if MEDIAWEEKENDDAYPOST6PM == 2
replace TVDUR4 = 3 if MEDIAWEEKENDDAYPOST6PM == 3
replace TVDUR4 = 5 if MEDIAWEEKENDDAYPOST6PM == 4
replace TVDUR4 = 7 if MEDIAWEEKENDDAYPOST6PM == 5
replace TVDUR4 = 9 if MEDIAWEEKENDDAYPOST6PM == 6
gen DURTV = (TVDUR1+TVDUR2+TVDUR3+TVDUR4)/7


/* FLIGHTS OF STAIRS */
gen STAIRFLIGHT1 = . if STAIRCLIMBINGWEEKDAY == . & MISSINGA == 1 /* 'Not completed'*/
replace STAIRFLIGHT1 = 15 if STAIRCLIMBINGWEEKDAY == . & MISSINGA == 2 /* 'Not completed, impute median'*/
replace STAIRFLIGHT1 = 0 if STAIRCLIMBINGWEEKDAY == 1
replace STAIRFLIGHT1 = 15 if STAIRCLIMBINGWEEKDAY == 2
replace STAIRFLIGHT1 = 40 if STAIRCLIMBINGWEEKDAY == 3
replace STAIRFLIGHT1 = 65 if STAIRCLIMBINGWEEKDAY == 4
replace STAIRFLIGHT1 = 90 if STAIRCLIMBINGWEEKDAY == 5
replace STAIRFLIGHT1 = 115 if STAIRCLIMBINGWEEKDAY == 6
gen STAIRFLIGHT2 = . if STAIRCLIMBINGWEEKENDDAY == . & MISSINGA == 1 /* 'Not completed'*/
replace STAIRFLIGHT2 = 6 if STAIRCLIMBINGWEEKENDDAY == . & MISSINGA == 2 /* 'Not completed, impute median'*/
replace STAIRFLIGHT2 = 0 if STAIRCLIMBINGWEEKENDDAY == 1
replace STAIRFLIGHT2 = 6 if STAIRCLIMBINGWEEKENDDAY == 2
replace STAIRFLIGHT2 = 16 if STAIRCLIMBINGWEEKENDDAY == 3
replace STAIRFLIGHT2 = 26 if STAIRCLIMBINGWEEKENDDAY == 4
replace STAIRFLIGHT2 = 36 if STAIRCLIMBINGWEEKENDDAY == 5
replace STAIRFLIGHT2 = 46 if STAIRCLIMBINGWEEKENDDAY == 6
*assign 10 seconds per flights of stairs
gen DURSTAIRFLIGHT = ((STAIRFLIGHT1+STAIRFLIGHT2)/7)/360

*HOME ACTIVITIES
*ignore in AEE calculations?
gen DURPREPFOOD = . if prepfood == . & MISSINGA == 1 /* 'Not completed' */
replace DURPREPFOOD = 4.5/7 if prepfood == . & MISSINGA == 2 /* 'Not completed, impute median' */
replace DURPREPFOOD = 0 if prepfood == 1
replace DURPREPFOOD = 0.5/7 if prepfood == 2
replace DURPREPFOOD = 2/7 if prepfood == 3
replace DURPREPFOOD = 4.5/7 if prepfood == 4
replace DURPREPFOOD = 8/7 if prepfood == 5
replace DURPREPFOOD = 12.5/7 if prepfood == 6
replace DURPREPFOOD = 17.5/7 if prepfood == 7

gen DURSHOPFOOD = . if shopfood == . & MISSINGA == 1 /* 'Not completed' */
replace DURSHOPFOOD = 2/7 if shopfood == . & MISSINGA == 2 /* 'Not completed, impute median' */
replace DURSHOPFOOD = 0 if shopfood == 1
replace DURSHOPFOOD = 0.5/7 if shopfood == 2
replace DURSHOPFOOD = 2/7 if shopfood == 3
replace DURSHOPFOOD = 4.5/7 if shopfood == 4
replace DURSHOPFOOD = 8/7 if shopfood == 5
replace DURSHOPFOOD = 12.5/7 if shopfood == 6
replace DURSHOPFOOD = 17.5/7 if shopfood == 7

gen DURSHOPELSE = . if shopelse == . & MISSINGA == 1 /* 'Not completed' */
replace DURSHOPELSE = 0.5/7 if shopelse == . & MISSINGA == 2 /* 'Not completed, impute median' */
replace DURSHOPELSE = 0 if shopelse == 1
replace DURSHOPELSE = 0.5/7 if shopelse == 2
replace DURSHOPELSE = 2/7 if shopelse == 3
replace DURSHOPELSE = 4.5/7 if shopelse == 4
replace DURSHOPELSE = 8/7 if shopelse == 5
replace DURSHOPELSE = 12.5/7 if shopelse == 6
replace DURSHOPELSE = 17.5/7 if shopelse == 7

gen DURCLEANHSE = . if cleanhse == . & MISSINGA == 1 /* 'Not completed' */
replace DURCLEANHSE = 2/7 if cleanhse == . & MISSINGA == 2 /* 'Not completed, impute median' */
replace DURCLEANHSE = 0 if cleanhse == 1
replace DURCLEANHSE = 0.5/7 if cleanhse == 2
replace DURCLEANHSE = 2/7 if cleanhse == 3
replace DURCLEANHSE = 4.5/7 if cleanhse == 4
replace DURCLEANHSE = 8/7 if cleanhse == 5
replace DURCLEANHSE = 12.5/7 if cleanhse == 6
replace DURCLEANHSE = 17.5/7 if cleanhse == 7

gen DURLAUNDRY = . if laundry == . & MISSINGA == 1 /* 'Not completed' */
replace DURLAUNDRY = 2/7 if laundry == . & MISSINGA == 2 /* 'Not completed, impute median' */
replace DURLAUNDRY = 0 if laundry == 1
replace DURLAUNDRY = 0.5/7 if laundry == 2
replace DURLAUNDRY = 2/7 if laundry == 3
replace DURLAUNDRY = 4.5/7 if laundry == 4
replace DURLAUNDRY = 8/7 if laundry == 5
replace DURLAUNDRY = 12.5/7 if laundry == 6
replace DURLAUNDRY = 17.5/7 if laundry == 7

gen DURBABYCARE = . if babycare == . & MISSINGA == 1 /* 'Not completed' */
replace DURBABYCARE = 0 if babycare == . & MISSINGA == 2 /* 'Not completed, impute median' */
replace DURBABYCARE = 0 if babycare == 1
replace DURBABYCARE = 0.5/7 if babycare == 2
replace DURBABYCARE = 2/7 if babycare == 3
replace DURBABYCARE = 4.5/7 if babycare == 4
replace DURBABYCARE = 8/7 if babycare == 5
replace DURBABYCARE = 12.5/7 if babycare == 6
replace DURBABYCARE = 17.5/7 if babycare == 7

gen DUROLDCARE = . if oldcare == . & MISSINGA == 1 /* 'Not completed' */
replace DUROLDCARE = 0 if oldcare == . & MISSINGA == 2 /* 'Not completed, impute median' */
replace DUROLDCARE = 0 if oldcare == 1
replace DUROLDCARE = 0.5/7 if oldcare == 2
replace DUROLDCARE = 2/7 if oldcare == 3
replace DUROLDCARE = 4.5/7 if oldcare == 4
replace DUROLDCARE = 8/7 if oldcare == 5
replace DUROLDCARE = 12.5/7 if oldcare  == 6
replace DUROLDCARE = 17.5/7 if oldcare == 7

egen DURHOMEACT = rowtotal(DURPREPFOOD DURSHOPFOOD DURSHOPELSE DURCLEANHSE DURLAUNDRY DURBABYCARE DUROLDCARE)




/* JOB ACTIVITY */
*ignore job 3
*truncate reported total work durations
replace jonehr = 84 if jonehr > 84 & jonehr !=.
replace jtwohr = 84 if jtwohr > 84 & jtwohr !=.

replace jonemo = 12 if jonemo > 12 & jonemo !=.
replace jtwomo = 12 if jtwomo > 12 & jtwomo !=.

replace jonemo = 12 if jonehr>0 & jonehr!=. & jonemo==.
replace jtwomo = 12 if jtwohr>0 & jtwohr!=. & jtwomo==.

/* For people who are missing the hours or months for their only job, impute medians from all people who have one job */
su jonehr if MISSINGJOB1 ==2 & MISSINGJOB2==1, d
replace jonehr = r(p50) if jonehr==. & MISSINGJOB1 ==2 & MISSINGJOB2==1
replace jtwohr = r(p50) if jtwohr==. & MISSINGJOB2 ==2 & MISSINGJOB1==1
su jonemo if MISSINGJOB1 ==2 & MISSINGJOB2==1, d
replace jonemo = r(p50) if jonemo==. & MISSINGJOB1 ==2 & MISSINGJOB2==1
replace jtwomo = r(p50) if jtwomo==. & MISSINGJOB2 ==2 & MISSINGJOB1==1

/* For people who are missing the hours or months for one of two jobs, impute medians from all people who have two jobs */
su jonehr if MISSINGJOB1 ==2 & MISSINGJOB2==2, d
replace jonehr = r(p50) if jonehr==. & MISSINGJOB1 ==2 & MISSINGJOB2==2
su jonemo if MISSINGJOB1 ==2 & MISSINGJOB2==2, d
replace jonemo = r(p50) if jonemo==. & MISSINGJOB1 ==2 & MISSINGJOB2==2

su jtwohr if MISSINGJOB1 ==2 & MISSINGJOB2==2, d
replace jtwohr = r(p50) if jtwohr==. & MISSINGJOB1 ==2 & MISSINGJOB2==2
su jtwomo if MISSINGJOB1 ==2 & MISSINGJOB2==2, d
replace jtwomo = r(p50) if jtwomo==. & MISSINGJOB1 ==2 & MISSINGJOB2==2


/*calculate duration of job 1 and 2 per day, taking number of months job is executed into account*/
gen DURJOB1 = (jonehr*(jonemo/12))/7 if MISSINGJOB==2
gen DURJOB2 = (jtwohr*(jtwomo/12))/7 if MISSINGJOB==2
egen DURJOB = rowtotal(DURJOB1 DURJOB2) if MISSINGJOB ==2
replace DURJOB = . if DURJOB1==. & DURJOB2==.


if version>=4 & version<=5 {
gen stairone = j1stairs
recode stairone 1=0 2=3 3=8 4=13 5=18 6=23 
gen laddone = j1ladder
recode laddone 1=0 2=3 3=8 4=13 5=18 6=23
gen stairtwo = j2stairs
recode stairtwo 1=0 2=3 3=8 4=13 5=18 6=23
gen laddtwo = j2ladder
recode laddtwo 1=0 2=3 3=8 4=13 5=18 6=23
}

/*calculate duration of subcomponents job 1 and 2 for individuals reporting 'yes' to subcomponent*/
gen DURSITAONE = sitaoneh if sitaone==2 & MISSINGJOB ==2
gen DURSITBONE = sitboneh if sitbone==2 & MISSINGJOB ==2
gen DURSTANDAONE = staaoneh if staaone==2 & MISSINGJOB ==2
gen DURSTANDBONE = staboneh if stabone==2 & MISSINGJOB ==2
gen DURSTANDCONE = staconeh if stacone==2 & MISSINGJOB ==2
gen DURSTANDDONE = stadoneh if stadone==2 & MISSINGJOB ==2
gen DURWALKAONE = walaoneh if walaone==2 & MISSINGJOB ==2
gen DURWALKBONE = walboneh if walbone==2 & MISSINGJOB ==2
gen DURMOVINGONE = movoneh if movone==2 & MISSINGJOB ==2
gen DURSTAIRSONE = stairone*5*10/(60*60) & MISSINGJOB ==2
gen DURLADDERONE = laddone*5*10/(60*60) & MISSINGJOB ==2

gen DURSITATWO = sitatwoh if sitatwo==2 & MISSINGJOB ==2
gen DURSITBTWO = sitbtwoh if sitbtwo==2 & MISSINGJOB ==2
gen DURSTANDATWO = staatwoh if staatwo==2 & MISSINGJOB ==2
gen DURSTANDBTWO = stabtwoh if stabtwo==2 & MISSINGJOB ==2
gen DURSTANDCTWO = stactwoh if stactwo==2 & MISSINGJOB ==2
gen DURSTANDDTWO = stadtwoh if stadtwo==2 & MISSINGJOB ==2
gen DURWALKATWO = walatwoh if walatwo==2 & MISSINGJOB ==2
gen DURWALKBTWO = walbtwoh if walbtwo==2 & MISSINGJOB ==2
gen DURMOVINGTWO = movtwoh if movtwo==2 & MISSINGJOB ==2
gen DURSTAIRSTWO = stairtwo*5*10/(60*60) & MISSINGJOB ==2
gen DURLADDERTWO = laddtwo*5*10/(60*60) & MISSINGJOB ==2


/*impute median duration for subcomponents in individuals reporting 'yes' to subcomponent, but no duration*/
su DURSITAONE if sitaone==2 & MISSINGJOB ==2, d
replace DURSITAONE = r(p50) if sitaone==2 & DURSITAONE==. & MISSINGJOB ==2
su DURSITATWO if sitatwo==2 & MISSINGJOB ==2, d
replace DURSITATWO = r(p50) if sitatwo==2 & DURSITATWO==. & MISSINGJOB ==2

su DURSITBONE if sitbone==2 & MISSINGJOB ==2, d
replace DURSITBONE = r(p50) if sitbone==2 & DURSITBONE==. & MISSINGJOB ==2
su DURSITBTWO if sitbtwo==2 & MISSINGJOB ==2, d
replace DURSITBTWO = r(p50) if sitbtwo==2 & DURSITBTWO==. & MISSINGJOB ==2

su DURSTANDAONE if staaone==2 & MISSINGJOB ==2, d
replace DURSTANDAONE = r(p50) if staaone==2 & DURSTANDAONE==. & MISSINGJOB ==2
su DURSTANDATWO if staatwo==2 & MISSINGJOB ==2, d
replace DURSTANDATWO = r(p50) if staatwo==2 & DURSTANDATWO==. & MISSINGJOB ==2

su DURSTANDBONE if stabone==2 & MISSINGJOB ==2, d
replace DURSTANDBONE = r(p50) if stabone==2 & DURSTANDBONE==. & MISSINGJOB ==2
su DURSTANDBTWO if stabtwo==2 & MISSINGJOB ==2, d
replace DURSTANDBTWO = r(p50) if stabtwo==2 & DURSTANDBTWO==. & MISSINGJOB ==2

su DURSTANDCONE if stacone==2 & MISSINGJOB ==2, d
replace DURSTANDCONE = r(p50) if stacone==2 & DURSTANDCONE==. & MISSINGJOB ==2
su DURSTANDCTWO if stactwo==2 & MISSINGJOB ==2, d
replace DURSTANDCTWO = r(p50) if stactwo==2 & DURSTANDCTWO==. & MISSINGJOB ==2

su DURSTANDDONE if stadone==2 & MISSINGJOB ==2, d
replace DURSTANDDONE = r(p50) if stadone==2 & DURSTANDDONE==. & MISSINGJOB ==2
su DURSTANDCTWO if stactwo==2 & MISSINGJOB ==2, d
replace DURSTANDDTWO = r(p50) if stadtwo==2 & DURSTANDDTWO==. & MISSINGJOB ==2

su DURWALKAONE if walaone==2 & MISSINGJOB ==2, d
replace DURWALKAONE = r(p50) if walaone==2 & DURWALKAONE==. & MISSINGJOB ==2
su DURWALKATWO if walatwo==2 & MISSINGJOB ==2, d
replace DURWALKATWO = r(p50) if walatwo==2 & DURWALKATWO==. & MISSINGJOB ==2

su DURWALKBONE if walbone==2 & MISSINGJOB ==2, d
replace DURWALKBONE = r(p50) if walbone==2 & DURWALKBONE==. & MISSINGJOB ==2
su DURWALKBTWO if walbtwo==2 & MISSINGJOB ==2, d
replace DURWALKBTWO = r(p50) if walbtwo==2 & DURWALKBTWO==. & MISSINGJOB ==2

su DURMOVINGONE if movone==2 & MISSINGJOB ==2, d
replace DURMOVINGONE = r(p50) if movone==2 & DURMOVINGONE==. & MISSINGJOB ==2
su DURMOVINGTWO if movtwo==2 & MISSINGJOB ==2, d
replace DURMOVINGTWO = r(p50) if movtwo==2 & DURMOVINGTWO==. & MISSINGJOB ==2

/*calculating duration per week of subcomponents for job 1 and 2, taking into account the number of months the job is executed*/
gen DURSITA1_WEEK = (jonemo*(DURSITAONE/12)) if MISSINGJOB ==2
gen DURSITB1_WEEK = (jonemo*(DURSITBONE/12)) if MISSINGJOB ==2
gen DURSTANDA1_WEEK = (jonemo*(DURSTANDAONE/12)) if MISSINGJOB ==2
gen DURSTANDB1_WEEK = (jonemo*(DURSTANDBONE/12)) if MISSINGJOB ==2
gen DURSTANDC1_WEEK = (jonemo*(DURSTANDCONE/12)) if MISSINGJOB ==2
gen DURSTANDD1_WEEK = (jonemo*(DURSTANDDONE/12)) if MISSINGJOB ==2
gen DURWALKA1_WEEK = (jonemo*(DURWALKAONE/12)) if MISSINGJOB ==2
gen DURWALKB1_WEEK = (jonemo*(DURWALKBONE/12)) if MISSINGJOB ==2
gen DURMOV1_WEEK = (jonemo*(DURMOVINGONE/12)) if MISSINGJOB ==2
gen DURSTAIRS1_WEEK = (jonemo*(DURSTAIRSONE/12)) if MISSINGJOB ==2
gen DURLADDER1_WEEK = (jonemo*(DURLADDERONE/12)) if MISSINGJOB ==2

gen DURSITA2_WEEK = (jtwomo*(DURSITATWO/12)) if MISSINGJOB ==2
gen DURSITB2_WEEK = (jtwomo*(DURSITBTWO/12)) if MISSINGJOB ==2
gen DURSTANDA2_WEEK = (jtwomo*(DURSTANDATWO/12)) if MISSINGJOB ==2
gen DURSTANDB2_WEEK = (jtwomo*(DURSTANDBTWO/12)) if MISSINGJOB ==2
gen DURSTANDC2_WEEK = (jtwomo*(DURSTANDCTWO/12)) if MISSINGJOB ==2
gen DURSTANDD2_WEEK = (jtwomo*(DURSTANDDTWO/12)) if MISSINGJOB ==2
gen DURWALKA2_WEEK = (jtwomo*(DURWALKATWO/12)) if MISSINGJOB ==2
gen DURWALKB2_WEEK = (jtwomo*(DURWALKBTWO/12)) if MISSINGJOB ==2
gen DURMOV2_WEEK = (jtwomo*(DURMOVINGTWO/12)) if MISSINGJOB ==2
gen DURSTAIRS2_WEEK = (jtwomo*(DURSTAIRSTWO/12)) if MISSINGJOB ==2
gen DURLADDER2_WEEK = (jtwomo*(DURLADDERTWO/12)) if MISSINGJOB ==2

/*calculating sum (in hrs/day) of subcomponents for job 1 and 2 to result in total reported work activity*/
egen DURJOBONE_REP = rowtotal(DURSITA1_WEEK DURSITB1_WEEK DURSTANDA1_WEEK DURSTANDB1_WEEK DURSTANDC1_WEEK DURSTANDD1_WEEK ///
	 DURWALKA1_WEEK DURWALKB1_WEEK DURMOV1_WEEK) if MISSINGJOB ==2
egen DURJOBTWO_REP = rowtotal(DURSITA2_WEEK DURSITB2_WEEK DURSTANDA2_WEEK DURSTANDB2_WEEK DURSTANDC2_WEEK DURSTANDD2_WEEK ///
	 DURWALKA2_WEEK DURWALKB2_WEEK DURMOV2_WEEK) if MISSINGJOB ==2
 
replace DURJOBONE_REP = DURJOBONE_REP/7 if MISSINGJOB ==2
replace DURJOBTWO_REP = DURJOBTWO_REP/7 if MISSINGJOB ==2

/*Scaling factor for those reporting more in domains of PA at work than their overall working hours*/
gen scalejobone = DURJOB1/DURJOBONE_REP
gen scalejobtwo = DURJOB2/DURJOBTWO_REP

/*impute median for scalingfactor to scale down subcomponents of individuals with missing data on DURJOB1 and DURJOB2, who would otherwise not be scaled*/
su scalejobone, d
gen scalejobone_alt = r(p50) if MISSINGJOB==2
su scalejobtwo, d
gen scalejobtwo_alt = r(p50) if MISSINGJOB==2

/*scaling subcomponents of job1 and 2 in individuals with DURJOB1 and DURJOB2
  scaling subcomponents of job1 and 2 in individuals with missing data from DURJOB1 and DURJOB2*/
gen DURSITA1_DAY_SCALED = (DURSITA1_WEEK / 7)
replace DURSITA1_DAY_SCALED = (DURSITA1_WEEK / 7) * scalejobone if scalejobone!=. & DURJOBONE_REP > DURJOB1 & MISSINGJOB==2
replace DURSITA1_DAY_SCALED = (DURSITA1_WEEK / 7) * scalejobone_alt if DURJOB1==. & DURJOBONE_REP!=. & MISSINGJOB==2

gen DURSITB1_DAY_SCALED = (DURSITB1_WEEK / 7)
replace DURSITB1_DAY_SCALED = (DURSITB1_WEEK / 7) * scalejobone if scalejobone!=. & DURJOBONE_REP > DURJOB1 & MISSINGJOB==2
replace DURSITB1_DAY_SCALED = (DURSITB1_WEEK / 7) * scalejobone_alt if DURJOB1==. & DURJOBONE_REP!=. & MISSINGJOB==2

gen DURSTANDA1_DAY_SCALED = (DURSTANDA1_WEEK/7)
replace DURSTANDA1_DAY_SCALED = (DURSTANDA1_WEEK/7) * scalejobone if scalejobone!=. & DURJOBONE_REP > DURJOB1 & MISSINGJOB==2
replace DURSTANDA1_DAY_SCALED = (DURSTANDA1_WEEK / 7) * scalejobone_alt if DURJOB1==. & DURJOBONE_REP!=. & MISSINGJOB==2

gen DURSTANDB1_DAY_SCALED = (DURSTANDB1_WEEK/7)
replace DURSTANDB1_DAY_SCALED = (DURSTANDB1_WEEK/7) * scalejobone if scalejobone!=. & DURJOBONE_REP > DURJOB1 & MISSINGJOB==2
replace DURSTANDB1_DAY_SCALED = (DURSTANDB1_WEEK / 7) * scalejobone_alt if DURJOB1==. & DURJOBONE_REP!=. & MISSINGJOB==2

gen DURSTANDC1_DAY_SCALED = (DURSTANDC1_WEEK/7)
replace DURSTANDC1_DAY_SCALED = (DURSTANDC1_WEEK/7) * scalejobone if scalejobone!=. & DURJOBONE_REP > DURJOB1 & MISSINGJOB==2
replace DURSTANDC1_DAY_SCALED = (DURSTANDC1_WEEK / 7) * scalejobone_alt if DURJOB1==. & DURJOBONE_REP!=. & MISSINGJOB==2

gen DURSTANDD1_DAY_SCALED = (DURSTANDD1_WEEK/7)
replace DURSTANDD1_DAY_SCALED = (DURSTANDD1_WEEK/7) * scalejobone if scalejobone!=. & DURJOBONE_REP > DURJOB1 & MISSINGJOB==2
replace DURSTANDD1_DAY_SCALED = (DURSTANDD1_WEEK / 7) * scalejobone_alt if DURJOB1==. & DURJOBONE_REP!=. & MISSINGJOB==2

gen DURWALKA1_DAY_SCALED = (DURWALKA1_WEEK/7)
replace DURWALKA1_DAY_SCALED = (DURWALKA1_WEEK/7) * scalejobone if scalejobone!=. & DURJOBONE_REP > DURJOB1 & MISSINGJOB==2
replace DURWALKA1_DAY_SCALED = (DURWALKA1_WEEK / 7) * scalejobone_alt if DURJOB1==. & DURJOBONE_REP!=. & MISSINGJOB==2

gen DURWALKB1_DAY_SCALED = (DURWALKB1_WEEK/7)
replace DURWALKB1_DAY_SCALED = (DURWALKB1_WEEK/7) * scalejobone if scalejobone!=. & DURJOBONE_REP > DURJOB1 & MISSINGJOB==2
replace DURWALKB1_DAY_SCALED = (DURWALKB1_WEEK / 7) * scalejobone_alt if DURJOB1==. & DURJOBONE_REP!=. & MISSINGJOB==2

gen DURMOV1_DAY_SCALED = (DURMOV1_WEEK/7)
replace DURMOV1_DAY_SCALED = (DURMOV1_WEEK/7) * scalejobone if scalejobone!=. & DURJOBONE_REP > DURJOB1 & MISSINGJOB==2
replace DURMOV1_DAY_SCALED = (DURMOV1_WEEK / 7) * scalejobone_alt if DURJOB1==. & DURJOBONE_REP!=. & MISSINGJOB==2

gen DURSTAIRS1_DAY = (DURSTAIRS1_WEEK/7)
gen DURLADDER1_DAY = (DURLADDER1_WEEK/7)

gen DURSITA2_DAY_SCALED = (DURSITA2_WEEK / 7)
replace DURSITA2_DAY_SCALED = (DURSITA2_WEEK / 7) * scalejobtwo if scalejobtwo!=. & DURJOBTWO_REP > DURJOB2 & MISSINGJOB==2
replace DURSITA2_DAY_SCALED = (DURSITA2_WEEK / 7) * scalejobtwo_alt if DURJOB2==. & DURJOBTWO_REP!=. & MISSINGJOB==2

gen DURSITB2_DAY_SCALED = (DURSITB2_WEEK / 7)
replace DURSITB2_DAY_SCALED = (DURSITB2_WEEK / 7) * scalejobtwo if scalejobtwo!=. & DURJOBTWO_REP > DURJOB2 & MISSINGJOB==2
replace DURSITB2_DAY_SCALED = (DURSITB2_WEEK / 7) * scalejobtwo_alt if DURJOB2==. & DURJOBTWO_REP!=. & MISSINGJOB==2

gen DURSTANDA2_DAY_SCALED = (DURSTANDA2_WEEK/7)
replace DURSTANDA2_DAY_SCALED = (DURSTANDA2_WEEK/7) * scalejobtwo if scalejobtwo!=. & DURJOBTWO_REP > DURJOB2 & MISSINGJOB==2
replace DURSTANDA2_DAY_SCALED = (DURSTANDA2_WEEK / 7) * scalejobtwo_alt if DURJOB2==. & DURJOBTWO_REP!=. & MISSINGJOB==2

gen DURSTANDB2_DAY_SCALED = (DURSTANDB2_WEEK/7)
replace DURSTANDB2_DAY_SCALED = (DURSTANDB2_WEEK/7) * scalejobtwo if scalejobtwo!=. & DURJOBTWO_REP > DURJOB2 & MISSINGJOB==2
replace DURSTANDB2_DAY_SCALED = (DURSTANDB2_WEEK / 7) * scalejobtwo_alt if DURJOB2==. & DURJOBTWO_REP!=. & MISSINGJOB==2

gen DURSTANDC2_DAY_SCALED = (DURSTANDC2_WEEK/7)
replace DURSTANDC2_DAY_SCALED = (DURSTANDC2_WEEK/7) * scalejobtwo if scalejobtwo!=. & DURJOBTWO_REP > DURJOB2 & MISSINGJOB==2
replace DURSTANDC2_DAY_SCALED = (DURSTANDC2_WEEK / 7) * scalejobtwo_alt if DURJOB2==. & DURJOBTWO_REP!=. & MISSINGJOB==2

gen DURSTANDD2_DAY_SCALED = (DURSTANDD2_WEEK/7)
replace DURSTANDD2_DAY_SCALED = (DURSTANDD2_WEEK/7) * scalejobtwo if scalejobtwo!=. & DURJOBTWO_REP > DURJOB2 & MISSINGJOB==2
replace DURSTANDD2_DAY_SCALED = (DURSTANDD2_WEEK / 7) * scalejobtwo_alt if DURJOB2==. & DURJOBTWO_REP!=. & MISSINGJOB==2

gen DURWALKA2_DAY_SCALED = (DURWALKA2_WEEK/7)
replace DURWALKA2_DAY_SCALED = (DURWALKA2_WEEK/7) * scalejobtwo if scalejobtwo!=. & DURJOBTWO_REP > DURJOB2 & MISSINGJOB==2
replace DURWALKA2_DAY_SCALED = (DURWALKA2_WEEK / 7) * scalejobtwo_alt if DURJOB2==. & DURJOBTWO_REP!=. & MISSINGJOB==2

gen DURWALKB2_DAY_SCALED = (DURWALKB2_WEEK/7)
replace DURWALKB2_DAY_SCALED = (DURWALKB2_WEEK/7) * scalejobtwo if scalejobtwo!=. & DURJOBTWO_REP > DURJOB2 & MISSINGJOB==2
replace DURWALKB2_DAY_SCALED = (DURWALKB2_WEEK / 7) * scalejobtwo_alt if DURJOB2==. & DURJOBTWO_REP!=. & MISSINGJOB==2

gen DURMOV2_DAY_SCALED = (DURMOV2_WEEK/7)
replace DURMOV2_DAY_SCALED = (DURMOV2_WEEK/7) * scalejobtwo if scalejobtwo!=. & DURJOBTWO_REP > DURJOB2 & MISSINGJOB==2
replace DURMOV2_DAY_SCALED = (DURMOV2_WEEK / 7) * scalejobtwo_alt if DURJOB2==. & DURJOBTWO_REP!=. & MISSINGJOB==2

gen DURSTAIRS2_DAY = (DURSTAIRS2_WEEK/7)
gen DURLADDER2_DAY = (DURLADDER2_WEEK/7)
 
/*SUMMING ACROSS JOB 1 AND 2*/

/*calculating sum of subcomponents across job 1 and 2*/
egen DURSITA = rowtotal(DURSITA1_DAY_SCALED DURSITA2_DAY_SCALED) if MISSINGJOB ==2
egen DURSITB = rowtotal(DURSITB1_DAY_SCALED DURSITB2_DAY_SCALED) if MISSINGJOB ==2
egen DURSTANDA = rowtotal(DURSTANDA1_DAY_SCALED DURSTANDA2_DAY_SCALED) if MISSINGJOB ==2
egen DURSTANDB = rowtotal(DURSTANDB1_DAY_SCALED DURSTANDB2_DAY_SCALED) if MISSINGJOB ==2
egen DURSTANDC = rowtotal(DURSTANDC1_DAY_SCALED DURSTANDC2_DAY_SCALED) if MISSINGJOB ==2
egen DURSTANDD = rowtotal(DURSTANDD1_DAY_SCALED DURSTANDD2_DAY_SCALED) if MISSINGJOB ==2
egen DURWALKA = rowtotal(DURWALKA1_DAY_SCALED DURWALKA2_DAY_SCALED) if MISSINGJOB ==2
egen DURWALKB = rowtotal(DURWALKB1_DAY_SCALED DURWALKB2_DAY_SCALED) if MISSINGJOB ==2
egen DURMOV = rowtotal(DURMOV1_DAY_SCALED DURMOV2_DAY_SCALED) if MISSINGJOB ==2

egen DURSTAIRS = rowtotal(DURSTAIRS1_DAY DURSTAIRS2_DAY) if MISSINGJOB ==2
egen DURLADDER = rowtotal(DURLADDER1_DAY DURLADDER2_DAY) if MISSINGJOB ==2


/*sum up scaled subcomponents for job 1 and 2*/
egen DURJOBONE_REP_SCALED = rowtotal(DURSITA1_DAY_SCALED DURSITB1_DAY_SCALED DURSTANDA1_DAY_SCALED DURSTANDB1_DAY_SCALED DURSTANDC1_DAY_SCALED DURSTANDD1_DAY_SCALED ///
									DURWALKA1_DAY_SCALED DURWALKB1_DAY_SCALED DURMOV1_DAY_SCALED) if MISSINGJOB==2
egen DURJOBTWO_REP_SCALED = rowtotal(DURSITA2_DAY_SCALED DURSITB2_DAY_SCALED DURSTANDA2_DAY_SCALED DURSTANDB2_DAY_SCALED DURSTANDC2_DAY_SCALED DURSTANDD2_DAY_SCALED ///
									DURWALKA2_DAY_SCALED DURWALKB2_DAY_SCALED DURMOV2_DAY_SCALED) if MISSINGJOB==2

egen DURJOB_REP_SCALED = rowtotal(DURJOBONE_REP_SCALED DURJOBTWO_REP_SCALED) if MISSINGJOB ==2


gen DURSQUAT = .
gen DURKNEEL = .
gen DURGETUP = .

if version>=1 & version<=2 {
replace DURSQUAT = 0 if MISSINGJOB ==2
replace DURSQUAT = 1*5/7 if squat==1 & MISSINGJOB ==2
replace DURKNEEL = 0 if MISSINGJOB ==2
replace DURKNEEL = 1*5/7 if kneel==1 & MISSINGJOB ==2
replace DURGETUP = 0 if MISSINGJOB ==2
replace DURGETUP = 0.25*5/7 if get_up==1 & MISSINGJOB ==2
}

if version>=4 & version<=5 {
*note, order of 'yes' and 'no' boxes swapped in this version
replace DURSQUAT = 0 if MISSINGJOB ==2
replace DURSQUAT = 1*5/7 if (j1squat==2 | j2squat==2) & MISSINGJOB ==2
replace DURKNEEL = 0 if MISSINGJOB ==2
replace DURKNEEL = 1*5/7 if (j1kneel==2 | j2kneel==2) & MISSINGJOB ==2
replace DURGETUP = 0 if MISSINGJOB ==2
replace DURGETUP = 0.25*5/7 if (j1getup==2 | j2getup==2) & MISSINGJOB ==2
}

egen WorkIncSKGU = rowtotal(DURSITA DURSITB DURSTANDA DURSTANDB DURSTANDC DURSTANDD DURWALKA DURWALKB DURMOV DURSTAIRS DURLADDER DURSQUAT DURKNEEL DURGETUP) if MISSINGJOB == 2
gen SKGUscaling = DURJOB/WorkIncSKGU if WorkIncSKGU > DURJOB

replace DURSITA = DURSITA * SKGUscaling if SKGUscaling >0 & SKGUscaling <. & MISSINGJOB ==2
replace DURSITB = DURSITB * SKGUscaling if SKGUscaling >0 & SKGUscaling <. & MISSINGJOB ==2
replace DURSTANDA = DURSTANDA * SKGUscaling if SKGUscaling >0 & SKGUscaling <. & MISSINGJOB ==2
replace DURSTANDB = DURSTANDB * SKGUscaling if SKGUscaling >0 & SKGUscaling <. & MISSINGJOB ==2
replace DURSTANDC = DURSTANDC * SKGUscaling if SKGUscaling >0 & SKGUscaling <. & MISSINGJOB ==2
replace DURSTANDD = DURSTANDD * SKGUscaling if SKGUscaling >0 & SKGUscaling <. & MISSINGJOB ==2
replace DURWALKA = DURWALKA * SKGUscaling if SKGUscaling >0 & SKGUscaling <. & MISSINGJOB ==2
replace DURWALKB = DURWALKB * SKGUscaling if SKGUscaling >0 & SKGUscaling <. & MISSINGJOB ==2
replace DURMOV = DURMOV * SKGUscaling if SKGUscaling >0 & SKGUscaling <. & MISSINGJOB ==2
replace DURSTAIRS = DURSTAIRS * SKGUscaling if SKGUscaling >0 & SKGUscaling <. & MISSINGJOB ==2
replace DURLADDER = DURLADDER * SKGUscaling if SKGUscaling >0 & SKGUscaling <. & MISSINGJOB ==2
replace DURSQUAT = DURSQUAT * SKGUscaling if SKGUscaling >0 & SKGUscaling <. & MISSINGJOB ==2
replace DURKNEEL = DURKNEEL * SKGUscaling if SKGUscaling >0 & SKGUscaling <. & MISSINGJOB ==2
replace DURGETUP = DURGETUP * SKGUscaling if SKGUscaling >0 & SKGUscaling <. & MISSINGJOB ==2



/* TRANSPORTATION ACTIVITY */

rename wrkmiles_cleaned1 DISTWORKMILES_1
rename wrkmiles_cleaned2 DISTWORKMILES_2

*Truncation of total distance ****set maximum miles to 100miles for anyone claiming more than that as a distance
replace DISTWORKMILES_1 = 100 if (DISTWORKMILES_1 > 100 & DISTWORKMILES_1 != .)
replace DISTWORKMILES_2 = 100 if (DISTWORKMILES_2 > 100 & DISTWORKMILES_2 != .)

*truncate number of outward journeys to work
replace commutenoone_cleaned = 10 if (commutenoone_cleaned > 10 & commutenoone_cleaned != .)
replace commutenotwo_cleaned = 10 if (commutenotwo_cleaned > 10 & commutenotwo_cleaned != .)

*generate frequencies for the 4 modes of transport for job 1 and 2
gen FREQCARINI_1 = 0 if (carone < 1 | carone > 4) & MISSINGCOMMUT == 2 /* 'NOT COMPLETED'*/
replace FREQCARINI_1 = 0 if carone == 4 /* 'Never or rarely'*/
replace FREQCARINI_1 = .25 if carone == 3 /* 'Occasionally'*/
replace FREQCARINI_1 = .75 if carone == 2 /* 'Usually'*/
replace FREQCARINI_1 = 1 if carone == 1 /* 'Always'*/
gen FREQPUBLICINI_1 = 0 if (pubone < 1 | pubone > 4) & MISSINGCOMMUT == 2 /* 'NOT COMPLETED'*/
replace FREQPUBLICINI_1 = 0 if pubone == 4 /* 'Never or rarely'*/
replace FREQPUBLICINI_1 = .25 if pubone == 3 /* 'Occasionally'*/
replace FREQPUBLICINI_1 = .75 if pubone == 2 /* 'Usually'*/
replace FREQPUBLICINI_1 = 1 if pubone == 1 /* 'Always'*/
gen FREQCYCLEINI_1 = 0 if (bikone < 1 | bikone > 4) & MISSINGCOMMUT == 2 /* 'NOT COMPLETED'*/
replace FREQCYCLEINI_1 = 0 if bikone == 4 /* 'Never or rarely'*/
replace FREQCYCLEINI_1 = .25 if bikone == 3 /* 'Occasionally'*/
replace FREQCYCLEINI_1 = .75 if bikone == 2 /* 'Usually'*/
replace FREQCYCLEINI_1 = 1 if bikone == 1 /* 'Always'*/
gen FREQWALKINI_1 = 0 if (walone < 1 | walone > 4) & MISSINGCOMMUT == 2 /* 'NOT COMPLETED'*/
replace FREQWALKINI_1 = 0 if walone == 4 /* 'Never or rarely'*/
replace FREQWALKINI_1 = .25 if walone == 3 /* 'Occasionally'*/
replace FREQWALKINI_1 = .75 if walone == 2 /* 'Usually'*/
replace FREQWALKINI_1 = 1 if walone == 1 /* 'Always'*/
gen FREQTOTAL_1 = FREQCARINI_1 + FREQPUBLICINI_1 + FREQCYCLEINI_1 + FREQWALKINI_1

gen FREQCARINI_2 = 0 if (cartwo < 1 | cartwo > 4) & MISSINGCOMMUT == 2 /* 'NOT COMPLETED'*/
replace FREQCARINI_2 = 0 if cartwo == 4 /* 'Never or rarely'*/
replace FREQCARINI_2 = .25 if cartwo == 3 /* 'Occasionally'*/
replace FREQCARINI_2 = .75 if cartwo == 2 /* 'Usually'*/
replace FREQCARINI_2 = 1 if cartwo == 1 /* 'Always'*/
gen FREQPUBLICINI_2 = 0 if (pubtwo < 1 | pubtwo > 4) & MISSINGCOMMUT == 2 /* 'NOT COMPLETED'*/
replace FREQPUBLICINI_2 = 0 if pubtwo == 4 /* 'Never or rarely'*/
replace FREQPUBLICINI_2 = .25 if pubtwo == 3 /* 'Occasionally'*/
replace FREQPUBLICINI_2 = .75 if pubtwo == 2 /* 'Usually'*/
replace FREQPUBLICINI_2 = 1 if pubtwo == 1 /* 'Always'*/
gen FREQCYCLEINI_2 = 0 if (biktwo < 1 | biktwo > 4) & MISSINGCOMMUT == 2 /* 'NOT COMPLETED'*/
replace FREQCYCLEINI_2 = 0 if biktwo == 4 /* 'Never or rarely'*/
replace FREQCYCLEINI_2 = .25 if biktwo == 3 /* 'Occasionally'*/
replace FREQCYCLEINI_2 = .75 if biktwo == 2 /* 'Usually'*/
replace FREQCYCLEINI_2 = 1 if biktwo == 1 /* 'Always'*/
gen FREQWALKINI_2 = 0 if (waltwo < 1 | waltwo > 4) & MISSINGCOMMUT == 2 /* 'NOT COMPLETED'*/
replace FREQWALKINI_2 = 0 if waltwo == 4 /* 'Never or rarely'*/
replace FREQWALKINI_2 = .25 if waltwo == 3 /* 'Occasionally'*/
replace FREQWALKINI_2 = .75 if waltwo == 2 /* 'Usually'*/
replace FREQWALKINI_2 = 1 if waltwo == 1 /* 'Always'*/
gen FREQTOTAL_2 = FREQCARINI_2 + FREQPUBLICINI_2 + FREQCYCLEINI_2 + FREQWALKINI_2


*generate miles covered for the 4 modes of transport for job 1 and 2
gen CARMILES_1 = 0
replace CARMILES_1 = DISTWORKMILES_1 * FREQCARINI_1 if FREQCARINI_1 >= 0.25 & FREQCARINI_1 != .
gen PUBLICMILES_1 = 0
replace PUBLICMILES_1 = DISTWORKMILES_1 * FREQPUBLICINI_1 if FREQPUBLICINI_1  >= 0.25 & FREQPUBLICINI_1 != .
gen CYCLEMILES_1 = 0
replace CYCLEMILES_1 = DISTWORKMILES_1 * FREQCYCLEINI_1 if FREQCYCLEINI_1 >= 0.25 & FREQCYCLEINI_1 != .
gen WALKMILES_1 = 0 
replace WALKMILES_1 = DISTWORKMILES_1 * FREQWALKINI_1 if FREQWALKINI_1  >= 0.25 & FREQWALKINI_1 != .

gen TOTALTRAVMILES_DER_1 = CARMILES_1 + PUBLICMILES_1 + CYCLEMILES_1 + WALKMILES_1 

gen DISTFACTOR_1 = DISTWORKMILES_1/TOTALTRAVMILES_DER_1


gen CARMILES_2 = 0
replace CARMILES_2 = DISTWORKMILES_2 * FREQCARINI_2 if FREQCARINI_2 >= 0.25 & FREQCARINI_2 != .
gen PUBLICMILES_2 = 0
replace PUBLICMILES_2 = DISTWORKMILES_2 * FREQPUBLICINI_2 if FREQPUBLICINI_2  >= 0.25 & FREQPUBLICINI_2 !=.
gen CYCLEMILES_2 = 0
replace CYCLEMILES_2 = DISTWORKMILES_2 * FREQCYCLEINI_2 if FREQCYCLEINI_2 >= 0.25 & FREQCYCLEINI_2 !=.
gen WALKMILES_2 = 0 
replace WALKMILES_2 = DISTWORKMILES_2 * FREQWALKINI_2 if FREQWALKINI_2  >= 0.25 & FREQWALKINI_2 !=.

gen TOTALTRAVMILES_DER_2 = CARMILES_2 + PUBLICMILES_2 + CYCLEMILES_2 + WALKMILES_2

gen DISTFACTOR_2 = DISTWORKMILES_2/TOTALTRAVMILES_DER_2


		*Cater for multimodal commuting and rescale distances according to mode for job 1 and 2
		*We have made many assumptions here. we have only made amendements when the total frequency of travel is > 1.25. Eg when someone reports always travelling by car 
		*and walking, we make the assumption  that they drive most (90%) of the way. 

		replace CARMILES_1 = (0.5*DISTWORKMILES_1) if FREQCARINI_1 >= 0.25 & FREQPUBLICINI_1 >= 0.25 & FREQCYCLEINI_1 <0.25 & FREQWALKINI_1 < 0.25 & FREQTOTAL_1 >= 1.25
		replace PUBLICMILES_1 = (0.5*DISTWORKMILES_1) if FREQCARINI_1 >= 0.25 & FREQPUBLICINI_1 >= 0.25 & FREQCYCLEINI_1 <0.25 & FREQWALKINI_1 < 0.25& FREQTOTAL_1 >= 1.25

		replace CARMILES_1 = (0.95*DISTWORKMILES_1) if FREQCARINI_1 >= 0.25 & FREQCYCLEINI_1 >= 0.25 & FREQPUBLICINI_1 <0.25 & FREQWALKINI_1 < 0.25 & FREQTOTAL_1 >= 1.25
		replace CYCLEMILES_1 = (0.05*DISTWORKMILES_1) if FREQCARINI_1 >= 0.25 & FREQCYCLEINI_1 >= 0.25 & FREQPUBLICINI_1 <0.25 & FREQWALKINI_1 < 0.25 & FREQTOTAL_1 >= 1.25

		replace CARMILES_1 = (0.99*DISTWORKMILES_1) if FREQCARINI_1 >= 0.25 & FREQWALKINI_1 >= 0.25 & FREQCYCLEINI_1 <0.25 & FREQPUBLICINI_1 < 0.25 & FREQTOTAL_1 >= 1.25
		replace WALKMILES_1 = (0.01*DISTWORKMILES_1) if FREQCARINI_1 >= 0.25 & FREQWALKINI_1 >= 0.25  & FREQCYCLEINI_1 <0.25 & FREQPUBLICINI_1 < 0.25 & FREQTOTAL_1 >= 1.25

		replace PUBLICMILES_1 = (0.9*DISTWORKMILES_1) if FREQPUBLICINI_1 >= 0.25 & FREQCYCLEINI_1 >= 0.25 & FREQCARINI_1 <0.25 & FREQWALKINI_1 < 0.25 & FREQTOTAL_1 >= 1.25
		replace CYCLEMILES_1 = (0.1*DISTWORKMILES_1) if FREQPUBLICINI_1 >= 0.25 & FREQCYCLEINI_1 >= 0.25 & FREQCARINI_1 <0.25 & FREQWALKINI_1 < 0.25 & FREQTOTAL_1 >= 1.25

		replace PUBLICMILES_1 = (0.99*DISTWORKMILES_1) if FREQPUBLICINI_1 >= 0.25 & FREQWALKINI_1 >= 0.25 & FREQCYCLEINI_1 <0.25 & FREQCARINI_1 < 0.25 & FREQTOTAL_1 >= 1.25
		replace WALKMILES_1 = (0.01*DISTWORKMILES_1) if FREQPUBLICINI_1 >= 0.25 & FREQWALKINI_1 >= 0.25 & FREQCYCLEINI_1 <0.25 & FREQCARINI_1 < 0.25 &  FREQTOTAL_1 >= 1.25

 		replace CYCLEMILES_1 = (0.95*DISTWORKMILES_1) if FREQCYCLEINI_1 >= 0.25 & FREQWALKINI_1 >= 0.25 & FREQCARINI_1 <0.25 & FREQPUBLICINI_1 < 0.25 & FREQTOTAL_1 >= 1.25
		replace WALKMILES_1 = (0.05*DISTWORKMILES_1) if FREQCYCLEINI_1 >= 0.25 & FREQWALKINI_1 >= 0.25 & FREQCARINI_1 <0.25 & FREQPUBLICINI_1 < 0.25 &  FREQTOTAL_1 >= 1.25


		replace CARMILES_1 = (0.475*DISTWORKMILES_1) if FREQCARINI_1 >= 0.25 & FREQPUBLICINI_1 >= 0.25 & FREQCYCLEINI_1 >= 0.25 & FREQWALKINI_1 < 0.25 & FREQTOTAL_1 >= 1.25
		replace PUBLICMILES_1 = (0.475*DISTWORKMILES_1) if FREQCARINI_1 >= 0.25 & FREQPUBLICINI_1 >= 0.25 & FREQCYCLEINI_1 >= 0.25 & FREQWALKINI_1 < 0.25 & FREQTOTAL_1 >= 1.25		
		replace CYCLEMILES_1 = (0.05*DISTWORKMILES_1) if FREQCARINI_1 >= 0.25 & FREQPUBLICINI_1 >= 0.25 & FREQCYCLEINI_1 >= 0.25 & FREQWALKINI_1 < 0.25 & FREQTOTAL_1 >= 1.25

		replace CARMILES_1 = (0.495*DISTWORKMILES_1) if FREQCARINI_1 >= 0.25 & FREQPUBLICINI_1 >= 0.25 & FREQWALKINI_1 >= 0.25 & FREQCYCLEINI_1 <0.25 &  FREQTOTAL_1 >= 1.25
		replace PUBLICMILES_1 = (0.495*DISTWORKMILES_1) if FREQCARINI_1 >= 0.25 & FREQPUBLICINI_1 >= 0.25 & FREQWALKINI_1 >= 0.25 & FREQCYCLEINI_1 <0.25 &  FREQTOTAL_1 >= 1.25		
		replace WALKMILES_1 = (0.01*DISTWORKMILES_1) if FREQCARINI_1 >= 0.25 & FREQPUBLICINI_1 >= 0.25 & FREQWALKINI_1 >= 0.25 & FREQCYCLEINI_1 <0.25 & FREQTOTAL_1 >= 1.25

		replace CARMILES_1 = (0.9*DISTWORKMILES_1) if FREQCARINI_1 >= 0.25 & FREQCYCLEINI_1 >= 0.25 & FREQWALKINI_1 >= 0.25 & FREQPUBLICINI_1 < 0.25 & FREQTOTAL_1 >= 1.25
		replace CYCLEMILES_1 = (0.09*DISTWORKMILES_1) if FREQCARINI_1 >= 0.25 & FREQCYCLEINI_1 >= 0.25 & FREQWALKINI_1 >= 0.25 & FREQPUBLICINI_1 < 0.25 & FREQTOTAL_1 >= 1.25
		replace WALKMILES_1 = (0.01*DISTWORKMILES_1) if FREQCARINI_1 >= 0.25 & FREQCYCLEINI_1 >= 0.25 & FREQWALKINI_1 >= 0.25 & FREQPUBLICINI_1 < 0.25 & FREQTOTAL_1 >= 1.25
	
		replace PUBLICMILES_1 = (0.9*DISTWORKMILES_1) if FREQPUBLICINI_1 >= 0.25 & FREQCYCLEINI_1 >= 0.25 & FREQWALKINI_1 >= 0.25 & FREQCARINI_1 <0.25 & FREQTOTAL_1 >= 1.25
		replace CYCLEMILES_1 = (0.09*DISTWORKMILES_1) if FREQPUBLICINI_1 >= 0.25 & FREQCYCLEINI_1 >= 0.25 & FREQWALKINI_1 >= 0.25 & FREQCARINI_1 <0.25 & FREQTOTAL_1 >= 1.25
		replace WALKMILES_1 = (0.01*DISTWORKMILES_1) if FREQPUBLICINI_1 >= 0.25 & FREQCYCLEINI_1 >= 0.25 & FREQWALKINI_1 >= 0.25 & FREQCARINI_1 <0.25 & FREQTOTAL_1 >= 1.25
		

		replace CARMILES_1 = (0.45*DISTWORKMILES_1) if FREQCARINI_1 >= 0.25 & FREQPUBLICINI_1 >= 0.25 & FREQCYCLEINI_1 >= 0.25 & FREQWALKINI_1 >= 0.25 & FREQTOTAL_1 >= 1.25
		replace PUBLICMILES_1 = (0.45*DISTWORKMILES_1) if FREQCARINI_1 >= 0.25 & FREQPUBLICINI_1 >= 0.25 & FREQCYCLEINI_1 >= 0.25 & FREQWALKINI_1 >= 0.25 & FREQTOTAL_1 >= 1.25
		replace CYCLEMILES_1 = (0.09*DISTWORKMILES_1) if FREQCARINI_1 >= 0.25 & FREQPUBLICINI_1 >= 0.25 & FREQCYCLEINI_1 >= 0.25 & FREQWALKINI_1 >= 0.25 & FREQTOTAL_1 >= 1.25
		replace WALKMILES_1 = (0.01*DISTWORKMILES_1) if FREQCARINI_1 >= 0.25 & FREQPUBLICINI_1 >= 0.25 & FREQCYCLEINI_1 >= 0.25 & FREQWALKINI_1 >= 0.25 & FREQTOTAL_1 >= 1.25
		
		
		
		
		
		replace CARMILES_2 = (0.5*DISTWORKMILES_2) if FREQCARINI_2 >= 0.25 & FREQPUBLICINI_2 >= 0.25 & FREQCYCLEINI_2 <0.25 & FREQWALKINI_2 < 0.25 & FREQTOTAL_2 >= 1.25
		replace PUBLICMILES_2 = (0.5*DISTWORKMILES_2) if FREQCARINI_2 >= 0.25 & FREQPUBLICINI_2 >= 0.25 & FREQCYCLEINI_2 <0.25 & FREQWALKINI_2 < 0.25& FREQTOTAL_2 >= 1.25

		replace CARMILES_2 = (0.95*DISTWORKMILES_2) if FREQCARINI_2 >= 0.25 & FREQCYCLEINI_2 >= 0.25 & FREQPUBLICINI_2 <0.25 & FREQWALKINI_2 < 0.25 & FREQTOTAL_2 >= 1.25
		replace CYCLEMILES_2 = (0.05*DISTWORKMILES_2) if FREQCARINI_2 >= 0.25 & FREQCYCLEINI_2 >= 0.25 & FREQPUBLICINI_2 <0.25 & FREQWALKINI_2 < 0.25 & FREQTOTAL_2 >= 1.25

		replace CARMILES_2 = (0.99*DISTWORKMILES_2) if FREQCARINI_2 >= 0.25 & FREQWALKINI_2 >= 0.25 & FREQCYCLEINI_2 <0.25 & FREQPUBLICINI_2 < 0.25 & FREQTOTAL_2 >= 1.25
		replace WALKMILES_2 = (0.01*DISTWORKMILES_2) if FREQCARINI_2 >= 0.25 & FREQWALKINI_2 >= 0.25  & FREQCYCLEINI_2 <0.25 & FREQPUBLICINI_2 < 0.25 & FREQTOTAL_2 >= 1.25

		replace PUBLICMILES_2 = (0.9*DISTWORKMILES_2) if FREQPUBLICINI_2 >= 0.25 & FREQCYCLEINI_2 >= 0.25 & FREQCARINI_2 <0.25 & FREQWALKINI_2 < 0.25 & FREQTOTAL_2 >= 1.25
		replace CYCLEMILES_2 = (0.1*DISTWORKMILES_2) if FREQPUBLICINI_2 >= 0.25 & FREQCYCLEINI_2 >= 0.25 & FREQCARINI_2 <0.25 & FREQWALKINI_2 < 0.25 & FREQTOTAL_2 >= 1.25

		replace PUBLICMILES_2 = (0.99*DISTWORKMILES_2) if FREQPUBLICINI_2 >= 0.25 & FREQWALKINI_2 >= 0.25 & FREQCYCLEINI_2 <0.25 & FREQCARINI_2 < 0.25 & FREQTOTAL_2 >= 1.25
		replace WALKMILES_2 = (0.01*DISTWORKMILES_2) if FREQPUBLICINI_2 >= 0.25 & FREQWALKINI_2 >= 0.25 & FREQCYCLEINI_2 <0.25 & FREQCARINI_2 < 0.25 &  FREQTOTAL_2 >= 1.25

 		replace CYCLEMILES_2 = (0.95*DISTWORKMILES_2) if FREQCYCLEINI_2 >= 0.25 & FREQWALKINI_2 >= 0.25 & FREQCARINI_2 <0.25 & FREQPUBLICINI_2 < 0.25 & FREQTOTAL_2 >= 1.25
		replace WALKMILES_2 = (0.05*DISTWORKMILES_2) if FREQCYCLEINI_2 >= 0.25 & FREQWALKINI_2 >= 0.25 & FREQCARINI_2 <0.25 & FREQPUBLICINI_2 < 0.25 &  FREQTOTAL_2 >= 1.25


		replace CARMILES_2 = (0.475*DISTWORKMILES_2) if FREQCARINI_2 >= 0.25 & FREQPUBLICINI_2 >= 0.25 & FREQCYCLEINI_2 >= 0.25 & FREQWALKINI_2 < 0.25 & FREQTOTAL_2 >= 1.25
		replace PUBLICMILES_2 = (0.475*DISTWORKMILES_2) if FREQCARINI_2 >= 0.25 & FREQPUBLICINI_2 >= 0.25 & FREQCYCLEINI_2 >= 0.25 & FREQWALKINI_2 < 0.25 & FREQTOTAL_2 >= 1.25		
		replace CYCLEMILES_2 = (0.05*DISTWORKMILES_2) if FREQCARINI_2 >= 0.25 & FREQPUBLICINI_2 >= 0.25 & FREQCYCLEINI_2 >= 0.25 & FREQWALKINI_2 < 0.25 & FREQTOTAL_2 >= 1.25

		replace CARMILES_2 = (0.495*DISTWORKMILES_2) if FREQCARINI_2 >= 0.25 & FREQPUBLICINI_2 >= 0.25 & FREQWALKINI_2 >= 0.25 & FREQCYCLEINI_2 <0.25 &  FREQTOTAL_2 >= 1.25
		replace PUBLICMILES_2 = (0.495*DISTWORKMILES_2) if FREQCARINI_2 >= 0.25 & FREQPUBLICINI_2 >= 0.25 & FREQWALKINI_2 >= 0.25 & FREQCYCLEINI_2 <0.25 &  FREQTOTAL_2 >= 1.25		
		replace WALKMILES_2 = (0.01*DISTWORKMILES_2) if FREQCARINI_2 >= 0.25 & FREQPUBLICINI_2 >= 0.25 & FREQWALKINI_2 >= 0.25 & FREQCYCLEINI_2 <0.25 & FREQTOTAL_2 >= 1.25

		replace CARMILES_2 = (0.9*DISTWORKMILES_2) if FREQCARINI_2 >= 0.25 & FREQCYCLEINI_2 >= 0.25 & FREQWALKINI_2 >= 0.25 & FREQPUBLICINI_2 < 0.25 & FREQTOTAL_2 >= 1.25
		replace CYCLEMILES_2 = (0.09*DISTWORKMILES_2) if FREQCARINI_2 >= 0.25 & FREQCYCLEINI_2 >= 0.25 & FREQWALKINI_2 >= 0.25 & FREQPUBLICINI_2 < 0.25 & FREQTOTAL_2 >= 1.25
		replace WALKMILES_2 = (0.01*DISTWORKMILES_2) if FREQCARINI_2 >= 0.25 & FREQCYCLEINI_2 >= 0.25 & FREQWALKINI_2 >= 0.25 & FREQPUBLICINI_2 < 0.25 & FREQTOTAL_2 >= 1.25
	
		replace PUBLICMILES_2 = (0.9*DISTWORKMILES_2) if FREQPUBLICINI_2 >= 0.25 & FREQCYCLEINI_2 >= 0.25 & FREQWALKINI_2 >= 0.25 & FREQCARINI_2 <0.25 & FREQTOTAL_2 >= 1.25
		replace CYCLEMILES_2 = (0.09*DISTWORKMILES_2) if FREQPUBLICINI_2 >= 0.25 & FREQCYCLEINI_2 >= 0.25 & FREQWALKINI_2 >= 0.25 & FREQCARINI_2 <0.25 & FREQTOTAL_2 >= 1.25
		replace WALKMILES_2 = (0.01*DISTWORKMILES_2) if FREQPUBLICINI_2 >= 0.25 & FREQCYCLEINI_2 >= 0.25 & FREQWALKINI_2 >= 0.25 & FREQCARINI_2 <0.25 & FREQTOTAL_2 >= 1.25
		

		replace CARMILES_2 = (0.45*DISTWORKMILES_2) if FREQCARINI_2 >= 0.25 & FREQPUBLICINI_2 >= 0.25 & FREQCYCLEINI_2 >= 0.25 & FREQWALKINI_2 >= 0.25 & FREQTOTAL_2 >= 1.25
		replace PUBLICMILES_2 = (0.45*DISTWORKMILES_2) if FREQCARINI_2 >= 0.25 & FREQPUBLICINI_2 >= 0.25 & FREQCYCLEINI_2 >= 0.25 & FREQWALKINI_2 >= 0.25 & FREQTOTAL_2 >= 1.25
		replace CYCLEMILES_2 = (0.09*DISTWORKMILES_2) if FREQCARINI_2 >= 0.25 & FREQPUBLICINI_2 >= 0.25 & FREQCYCLEINI_2 >= 0.25 & FREQWALKINI_2 >= 0.25 & FREQTOTAL_2 >= 1.25
		replace WALKMILES_2 = (0.01*DISTWORKMILES_2) if FREQCARINI_2 >= 0.25 & FREQPUBLICINI_2 >= 0.25 & FREQCYCLEINI_2 >= 0.25 & FREQWALKINI_2 >= 0.25 & FREQTOTAL_2 >= 1.25


		
*Truncate Walking and Cycling distance
replace CYCLEMILES_1 = 20 if CYCLEMILES_1 > 20 & CYCLEMILES_1 !=.
replace WALKMILES_1 = 3 if WALKMILES_1 > 3 & WALKMILES_1 !=.

replace CYCLEMILES_2 = 20 if CYCLEMILES_2 > 20 & CYCLEMILES_2 !=.
replace WALKMILES_2 = 3 if WALKMILES_2 > 3 & WALKMILES_2 !=.

*Convert distances for job 1 and 2 taking into accounts the reported number of outbound trips and months per year the job is performed
*multiply by 2 to get round trips
replace WALKMILES_1 = WALKMILES_1 * (2*commutenoone_cleaned*(jonemo/12))/7
replace CYCLEMILES_1 = CYCLEMILES_1 * (2*commutenoone_cleaned*(jonemo/12))/7
replace CARMILES_1 = CARMILES_1 * (2*commutenoone_cleaned*(jonemo/12))/7
replace PUBLICMILES_1 = PUBLICMILES_1 * (2*commutenoone_cleaned*(jonemo/12))/7

replace WALKMILES_2 = WALKMILES_2 * (2*commutenotwo_cleaned*(jtwomo/12))/7
replace CYCLEMILES_2 = CYCLEMILES_2 * (2*commutenotwo_cleaned*(jtwomo/12))/7
replace CARMILES_2 = CARMILES_2 * (2*commutenotwo_cleaned*(jtwomo/12))/7
replace PUBLICMILES_2 = PUBLICMILES_2 * (2*commutenotwo_cleaned*(jtwomo/12))/7

*Generate durations per day for the four modes of commuting for job 1 and 2
*Assume speeds  of 3 mph for walking, 10 mph for cycling, 45 mph for driving a car and 30 mph for pubic transport

gen DURWALK_1 = (WALKMILES_1/3)
gen DURCYCLE_1 = (CYCLEMILES_1/10)
gen DURCAR_1 = (CARMILES_1/45)
gen DURPUBLIC_1 = (PUBLICMILES_1/30)

gen DURWALK_2 = (WALKMILES_2/3)
gen DURCYCLE_2 = (CYCLEMILES_2/10)
gen DURCAR_2 = (CARMILES_2/45)
gen DURPUBLIC_2 = (PUBLICMILES_2/30)

*Gerenate sum of distances across job 1 and 2
egen WALKMILES = rowtotal(WALKMILES_1 WALKMILES_2) if MISSINGCOMMUT ==2
egen CYCLEMILES = rowtotal(CYCLEMILES_1 CYCLEMILES_2) if MISSINGCOMMUT ==2
egen CARMILES = rowtotal(CARMILES_1 CARMILES_2) if MISSINGCOMMUT ==2
egen PUBLICMILES = rowtotal(PUBLICMILES_1 PUBLICMILES_2) if MISSINGCOMMUT ==2

*Generate sum of 4 modes of transport across job 1 and 2
egen DURWALK = rowtotal(DURWALK_1 DURWALK_2) if MISSINGCOMMUT ==2
egen DURCYCLE = rowtotal(DURCYCLE_1 DURCYCLE_2) if MISSINGCOMMUT ==2
egen DURCAR = rowtotal(DURCAR_1 DURCAR_2) if MISSINGCOMMUT ==2
egen DURPUBLIC = rowtotal(DURPUBLIC_1 DURPUBLIC_2) if MISSINGCOMMUT ==2


***************************
/* RECREATIONAL ACTIVITY */
/* Take frequencies reported in categories to frequencies per week */
***************************

foreach var in swimcomp_cleaned swimleis_cleaned backpackmountainclimb_cleaned walkpleasure_cleaned ///
cyclingracingrough_cleaned cyclepleasure_cleaned mowing_cleaned waterlawn_cleaned heavygardening_cleaned weedprune_cleaned ///
diy_cleaned aerobicshigh_cleaned aerobicsother_cleaned exerciseweights_cleaned conditionexercise_cleaned ///
floorexercise_cleaned dancing_cleaned comprun_cleaned jog_cleaned bowling_cleaned tennisbadminton_cleaned ///
squash_cleaned tabletennis_cleaned golf_cleaned footballrugbyhockey_cleaned cricket_cleaned rowing_cleaned ///
netvolleybasketball_cleaned huntingshootingfishing_c horsebased_cleaned snookerbillardsdarts_c musicalinstrumentsinging_c ///
iceskating_cleaned sailingwindsurfboating_c skiing_cleaned combatssports_cleaned  {

	replace `var' = 0 if (`var' == 1 | `var' ==.) & MISSINGC ==2
	replace `var' = 0.5/52 if `var' == 2
	replace `var' = 12/52 if `var' == 3
	replace `var' = (2.5*12)/52 if `var' == 4
	replace `var' = 1 if `var' == 5
	replace `var' = 2.5 if `var' == 6
	replace `var' = 4.5 if `var' == 7
	replace `var' = 7 if `var' == 8
}

/*set out of range reported durations to missing - 24hrs per episode deemed unrealistic! */
foreach x in swimcomp swimleis backpackmountainclimb  walkpleasure cyclingracingrough cyclepleasure mowing waterlawn heavygardening ///
weedprune diy aerobicshigh aerobicsother exerciseweights conditionexercise floorexercise dancing comprun jog bowling tennisbadminton ///
squash tabletennis golf footballrugbyhockey cricket rowing netvolleybasketball huntingshootingfishing horsebased snookerbillardsdarts ///
musicalinstrumentsinging iceskating sailingwindsurfboating skiing combatssports {
	*count if `x'hr_cl > 24 & `x'hr_cl!=.
	replace `x'hr_cl = . if `x'hr_cl >24 
}


***************************
/* Assign maximum duration to activities to address overreporting of the duration of an episode */
***************************
*truncated high durations


foreach x in exerciseweights squash {
replace `x'hr_cl = 2 if `x'hr_cl >2 & `x'hr_cl !=.
replace `x'min_cl = 0 if `x'hr_cl >=2 & `x'hr_cl !=. 
}

foreach x in mowing waterlawn aerobicshigh aerobicsother conditionexercise floorexercise footballrugbyhockey netvolleybasketball rowing combatssports {
replace `x'hr_cl = 3 if `x'hr_cl >3 & `x'hr_cl !=.
replace `x'min_cl = 0 if `x'hr_cl >=3 & `x'hr_cl !=. 
}

foreach x in swimcomp swimleis comprun jog bowling tennisbadminton tabletennis horsebased snookerbillardsdarts musicalinstrumentsinging iceskating {
replace `x'hr_cl = 4 if `x'hr_cl >4 & `x'hr_cl !=.
replace `x'min_cl = 0 if `x'hr_cl >=4 & `x'hr_cl !=. 
}

foreach x in skiing  {
replace `x'hr_cl = 5 if `x'hr_cl >5 & `x'hr_cl !=.
replace `x'min_cl = 0 if `x'hr_cl >=5 & `x'hr_cl !=. 
}

foreach x in backpackmountainclimb walkpleasure cyclingracingrough cyclepleasure heavygardening weedprune dancing cricket  {
replace `x'hr_cl = 8 if `x'hr_cl >8 & `x'hr_cl !=.
replace `x'min_cl = 0 if `x'hr_cl >=8 & `x'hr_cl !=. 
}

foreach x in diy golf huntingshootingfishing sailingwindsurfboating  {
replace `x'hr_cl = 10 if `x'hr_cl >10 & `x'hr_cl !=.
replace `x'min_cl = 0 if `x'hr_cl >=10 & `x'hr_cl !=. 
}


/* This code is not currently used - where frequency is missing it assign median frequency from those participating in the activity.
Instead missing frequencies are set to 0.

foreach x in swimcomp swimleis backpackmountainclimb  walkpleasure cyclingracingrough cyclepleasure mowing waterlawn heavygardening ///
weedprune diy aerobicshigh aerobicsother exerciseweights conditionexercise floorexercise dancing comprun jog bowling tennisbadminton ///
squash tabletennis golf footballrugbyhockey cricket rowing netvolleybasketball huntingshootingfishing horsebased snookerbillardsdarts ///
musicalinstrumentsinging iceskating sailingwindsurfboating skiing combatssports {
	
	su `x'_cle if `x'_cle > 0 & `x'_cl !=., detail
	replace `x'_cl = r(p50) if (`x'_cl <=0 | `x'_cl == .) & ((`x'hr_cl > 0 & `x'hr_cl !=.) | (`x'min_cl > 0 & `x'min_cl < 60))
	replace `x'_cl = 0 if (`x'_cl == . | `x'_cl < 0 ) & MISSINGC == 2
}
*/


*where no duration is reported (but frequency is) assign median duration from those participating in the activity 


foreach x in swimcomp swimleis backpackmountainclimb  walkpleasure cyclingracingrough cyclepleasure mowing waterlawn heavygardening ///
weedprune diy aerobicshigh aerobicsother exerciseweights conditionexercise floorexercise dancing comprun jog bowling tennisbadminton ///
squash tabletennis golf footballrugbyhockey cricket rowing netvolleybasketball huntingshootingfishing horsebased snookerbillardsdarts ///
musicalinstrumentsinging iceskating sailingwindsurfboating skiing combatssports {
	*count min> 60
	*count if `x'min_cl > 59 & `x'min_cl!=.
	*count if `x'min_cl > 119 & `x'min_cl!=.

/* The following 2 lines are needed as otherwise something very odd happens to the calculation of tot_`x'hr */
   	replace `x'hr_cl = 0 if `x'hr_cl ==. & MISSINGC ==2
	replace `x'min_cl = 0 if `x'min_cl ==. & MISSINGC ==2
	
	*generate total hrs of each activity
	gen tot_`x'hr = .

	*if they have duration >0 for the activity, put this duration in tot_`x'hr
	replace tot_`x'hr = (`x'hr_cl + (`x'min_cl/60)) if ((`x'hr_cl > 0 & `x'hr_cl !=.) | (`x'min_cl > 0 & `x'min_cl <=60))

	*summarise tot_`x'hr (to calculate the median)
	su tot_`x'hr if tot_`x'hr > 0, detail 

	*if they report a frequency for the activity, but no duration, put the median duration into tot_`x'hr
	replace tot_`x'hr = r(p50) if (tot_`x'hr  == .) & (`x'_clea > 0 & `x'_clea < 8)

	*set tot_`x'hr to 0 if it is still missing
	replace tot_`x'hr = 0 if (tot_`x'hr == . & MISSINGC == 2)
}


foreach x in swimcomp swimleis backpackmountainclimb  walkpleasure cyclingracingrough cyclepleasure mowing waterlawn heavygardening ///
weedprune diy aerobicshigh aerobicsother exerciseweights conditionexercise floorexercise dancing comprun jog bowling tennisbadminton ///
squash tabletennis golf footballrugbyhockey cricket rowing netvolleybasketball huntingshootingfishing horsebased snookerbillardsdarts ///
musicalinstrumentsinging iceskating sailingwindsurfboating skiing combatssports {

	*generate total hrs of each activity per day
	gen TOTDUR`x' = (tot_`x'hr * `x'_cl)/7

}


***************************
/* calculates total reported leisure time activities per day */
***************************

egen DURATIONLEIS = rowtotal(TOTDURswimcomp TOTDURswimleis TOTDURbackpackmountainclimb TOTDURwalkpleasure ///
TOTDURcyclingracingrough TOTDURcyclepleasure TOTDURmowing TOTDURwaterlawn TOTDURheavygardening ///
TOTDURweedprune TOTDURdiy TOTDURaerobicshigh TOTDURaerobicsother TOTDURexerciseweights ///
TOTDURconditionexercise TOTDURfloorexercise TOTDURdancing TOTDURcomprun TOTDURjog TOTDURbowling ///
TOTDURtennisbadminton TOTDURsquash TOTDURtabletennis TOTDURgolf TOTDURfootballrugbyhockey TOTDURcricket ///
TOTDURrowing TOTDURnetvolleybasketball TOTDURhuntingshootingfishing TOTDURhorsebased TOTDURsnookerbillardsdarts ///
TOTDURmusicalinstrumentsinging TOTDURiceskating TOTDURsailingwindsurfboating TOTDURskiing TOTDURcombatssports) if MISSINGC == 2


***************************
/* re-scale total reported activities per day if total is greater than 24hrs per day */
***************************
gen SLEEPadj = DURSLEEP
gen GETABOUTBIKEadj = DURGETABOUT_BIKE
gen GETABOUTWALKadj = DURGETABOUT_WALK
gen TVadj = DURTV
gen HOMEACTadj = DURHOMEACT
gen STAIRadj = DURSTAIRFLIGHT
gen JOBadj = DURJOB
gen CARadj = DURCAR
gen PUBLICadj = DURPUBLIC
gen CYCLEadj = DURCYCLE 
gen WALKadj = DURWALK
gen LEISadj = DURATIONLEIS

egen DURATIONINI = rowtotal(SLEEPadj GETABOUTBIKEadj GETABOUTWALKadj TVadj STAIRadj HOMEACTadj JOBadj CARadj PUBLICadj CYCLEadj WALKadj LEISadj) if (MISSINGA == 2 | MISSINGCOMMUT == 2 | MISSINGJOB == 2 | MISSINGC == 2)


	replace SLEEPadj = DURSLEEP*24/DURATIONINI if DURATIONINI > 24
	replace GETABOUTBIKEadj = DURGETABOUT_BIKE*24/DURATIONINI if DURATIONINI > 24
	replace GETABOUTWALKadj = DURGETABOUT_WALK*24/DURATIONINI if DURATIONINI > 24
	replace TVadj = DURTV*24/DURATIONINI if DURATIONINI > 24
	replace STAIRadj = DURSTAIRFLIGHT*24/DURATIONINI if DURATIONINI > 24
	replace JOBadj= DURJOB*24/DURATIONINI if DURATIONINI > 24
	replace CARadj = DURCAR*24/DURATIONINI if DURATIONINI > 24
	replace PUBLICadj = DURPUBLIC*24/DURATIONINI if DURATIONINI > 24
	replace CYCLEadj = DURCYCLE*24/DURATIONINI if DURATIONINI > 24
	replace WALKadj = DURWALK*24/DURATIONINI if DURATIONINI > 24


	foreach x in DURPREPFOOD DURSHOPFOOD DURSHOPELSE DURCLEANHSE DURLAUNDRY DURBABYCARE DUROLDCARE {
	gen `x'a = `x' 
	replace `x'a = `x'*24/DURATIONINI if DURATIONINI > 24
	}

	foreach x in DURSITA DURSITB DURSTANDA DURSTANDB DURSTANDC DURSTANDD DURWALKA DURWALKB DURMOV DURSTAIRS DURLADDER DURSQUAT DURKNEEL DURGETUP{
	gen `x'a = `x' 
	replace `x'a = `x'*24/DURATIONINI if DURATIONINI > 24
	}

	
foreach x in TOTDURswimcomp TOTDURswimleis TOTDURbackpackmountainclimb TOTDURwalkpleasure ///
TOTDURcyclingracingrough TOTDURcyclepleasure TOTDURmowing TOTDURwaterlawn TOTDURheavygardening ///
TOTDURweedprune TOTDURdiy TOTDURaerobicshigh TOTDURaerobicsother TOTDURexerciseweights ///
TOTDURconditionexercise TOTDURfloorexercise TOTDURdancing TOTDURcomprun TOTDURjog TOTDURbowling ///
TOTDURtennisbadminton TOTDURsquash TOTDURtabletennis TOTDURgolf TOTDURfootballrugbyhockey TOTDURcricket ///
TOTDURrowing TOTDURnetvolleybasketball TOTDURhuntingshootingfishing TOTDURhorsebased TOTDURsnookerbillardsdarts ///
TOTDURmusicalinstrumentsinging TOTDURiceskating TOTDURsailingwindsurfboating TOTDURskiing TOTDURcombatssports {
	gen `x'a = `x' 
	replace `x'a = `x'*24/DURATIONINI if DURATIONINI > 24
	}

*generate adjusted durations for each domain considering maximum value of 24 for total activities


*SLEEP
gen SLEEPtime = SLEEPadj

*HOME
egen HOMEtime = rowtotal(GETABOUTBIKEadj GETABOUTWALKadj TVadj STAIRadj DURPREPFOODa DURSHOPFOODa ///
DURSHOPELSEa DURCLEANHSEa DURLAUNDRYa DURBABYCAREa DUROLDCAREa) if MISSINGA == 2

*WORK

egen WORKtime = rowtotal(DURSITAa DURSITBa DURSTANDAa DURSTANDBa DURSTANDCa DURSTANDDa DURWALKAa DURWALKBa DURMOVa DURSTAIRSa DURLADDERa DURSQUATa DURKNEELa DURGETUPa) if MISSINGJOB == 2

*COMMUTING

egen COMMUTEtime = rowtotal(CARadj PUBLICadj CYCLEadj WALKadj) if MISSINGCOMMUT == 2

*LEISURE

egen LEIStime = rowtotal(TOTDURswimcompa TOTDURswimleisa TOTDURbackpackmountainclimba TOTDURwalkpleasurea ///
TOTDURcyclingracingrougha TOTDURcyclepleasurea TOTDURmowinga TOTDURwaterlawna TOTDURheavygardeninga ///
TOTDURweedprunea TOTDURdiya TOTDURaerobicshigha TOTDURaerobicsothera TOTDURexerciseweightsa ///
TOTDURconditionexercisea TOTDURfloorexercisea TOTDURdancinga TOTDURcompruna TOTDURjoga TOTDURbowlinga ///
TOTDURtennisbadmintona TOTDURsquasha TOTDURtabletennisa TOTDURgolfa TOTDURfootballrugbyhockeya TOTDURcricketa ///
TOTDURrowinga TOTDURnetvolleybasketballa TOTDURhuntingshootingfishinga TOTDURhorsebaseda TOTDURsnookerbillardsdartsa ///
TOTDURmusicalinstrumentsinginga TOTDURiceskatinga TOTDURsailingwindsurfboatinga TOTDURskiinga TOTDURcombatssportsa) if MISSINGC == 2

egen TOTALtime = rowtotal(SLEEPtime HOMEtime WORKtime COMMUTEtime LEIStime)


***************************
/* UNACCOUNTED_TIME = Time not accounted for by EPAQ2 */
***************************

gen UNACCOUNTED_TIME = .

replace UNACCOUNTED_TIME = 24 -(TOTALtime) if TOTALtime <= 24
replace UNACCOUNTED_TIME = 0 if TOTALtime > 24

/* Unaccounted time at work is included in this total (e.g. if someone reported spending 7 hrs/day at work 
   but sitting=3h, walking=1h, that leaves 3h/day unaccounted time). Using TOTALtime in this calculation adds this 
   unaccounted work time to the UNACCOUNTED_TIME total, as TOTALtime uses the sum of reported work components (WORKtime) 
   not the total reported work time (DURJOB, which may include unaccounted time). */

   
***************************
/* Calculation of MET scores using Ainsworth's compendium*/
***************************

gen SCORESLEEP = 0.9 * SLEEPadj

/* Home section */

gen SCOREGETABOUTBIKE = 4.0 * GETABOUTBIKEadj
gen SCOREGETABOUTWALK = 3.5 * GETABOUTWALKadj

gen SCORETV = TVadj*1.0

*stairs is halfway between 8 for going up and 3 for going down
gen SCORESTAIRS = STAIRadj*5.5

gen SCOREPREPFOOD = 2.50 * DURPREPFOODa      
gen SCORESHOPFOOD = 2.75 * DURSHOPFOODa
gen SCORESHOPELSE = 2.00 * DURSHOPELSEa
gen SCORECLEANHSE = 2.50 * DURCLEANHSEa
gen SCORELAUNDRY  = 2.00 * DURLAUNDRYa
gen SCOREBABYCARE = 2.50 * DURBABYCAREa
gen SCOREOLDCARE  = 1.50 * DUROLDCAREa

egen SCOREHOME = rowtotal(SCOREGETABOUTBIKE SCOREGETABOUTWALK SCORETV SCOREPREPFOOD SCORESHOPFOOD SCORESHOPELSE ///
SCORECLEANHSE SCORELAUNDRY SCOREBABYCARE SCOREOLDCARE SCORESTAIRS)
replace SCOREHOME = . if MISSINGA == 1

gen UNACCOUNTED_MET = 1.0 * UNACCOUNTED_TIME


/* Work section */

gen SCORESITA   = 1.5 * DURSITAa if MISSINGJOB ==2
gen SCORESITB   = 2.5 * DURSITBa  if MISSINGJOB ==2
gen SCORESTANDA = 2.3 * DURSTANDAa if MISSINGJOB ==2
gen SCORESTANDB = 3.0 * DURSTANDBa  if MISSINGJOB ==2
gen SCORESTANDC = 3.5 * DURSTANDCa  if MISSINGJOB ==2
gen SCORESTANDD = 4.0 * DURSTANDDa  if MISSINGJOB ==2
gen SCOREWALKA  = 2.5 * DURWALKAa  if MISSINGJOB ==2
gen SCOREWALKB  = 4.5 * DURWALKBa  if MISSINGJOB ==2
gen SCOREMOV    = 7.5 * DURMOVa  if MISSINGJOB ==2

gen SCOREJOBSTAIRS = 5.5 * DURSTAIRSa  if MISSINGJOB ==2
gen SCORELADDER = 8.0 * DURLADDERa if MISSINGJOB ==2

gen SCORESQUAT  = 2.0 * DURSQUAT if MISSINGJOB ==2
gen SCOREKNEEL  = 2.0 * DURKNEEL if MISSINGJOB ==2
gen SCOREGETUP  = 2.0 * DURGETUP if MISSINGJOB ==2

 
egen SCOREJOB = rowtotal(SCORESITA SCORESITB SCORESTANDA SCORESTANDB SCORESTANDC SCORESTANDD SCOREWALKA SCOREWALKB ///
SCOREMOV SCOREJOBSTAIRS SCORELADDER SCORESQUAT SCOREKNEEL SCOREGETUP)


/* Commuting section */
gen SCORECAR = 1.5 *CARadj	/*Compendium says driving 2METs, riding 1MET*/
gen SCOREPUBLIC = 1.0 *PUBLICadj
gen SCORECYCLE = 6.0 *CYCLEadj
gen SCOREWALK = 3.3 *WALKadj
egen SCORECOMMUTE = rowtotal(SCORECAR SCOREPUBLIC SCORECYCLE SCOREWALK)
replace SCORECOMMUTE = . if MISSINGCOMMUT == 1


*Generate MET scores for LTPA variables
/* Recreation section */
gen SCORELAPSWI = TOTDURswimcompa *10
gen SCORELESSWI = TOTDURswimleisa *6
gen SCOREBAKPAK = TOTDURbackpackmountainclimba *7 
gen SCOREWALKPLEASURE = TOTDURwalkpleasurea *3.5
gen SCORECYCRAC = TOTDURcyclingracingrougha *10
gen SCORECYCPLE = TOTDURcyclepleasurea *4
gen SCORELAWN = TOTDURmowinga *5.5
gen SCOREWATER = TOTDURwaterlawna *1.5
gen SCOREDIG = TOTDURheavygardeninga *6
gen SCOREWEED = TOTDURweedprunea *4.5
gen SCOREDIY = TOTDURdiya *4.5
gen SCORESTEP = TOTDURaerobicshigha *7
gen SCOREAERO = TOTDURaerobicsothera *5
gen SCOREWGHT = TOTDURexerciseweightsa *3
gen SCOREEXER = TOTDURconditionexercisea *5.5
gen SCOREFLOOR = TOTDURfloorexercisea *4
gen SCOREDANCE = TOTDURdancinga *4.5
gen SCORECOMRUN = TOTDURcompruna *12.5
gen SCOREJOG = TOTDURjoga *7
gen SCOREBOWL = TOTDURbowlinga *3
gen SCORETENBAD = TOTDURtennisbadmintona *6
gen SCORESQUASH = TOTDURsquasha *12
gen SCORETABTEN = TOTDURtabletennisa *4
gen SCOREGOLF = TOTDURgolfa *4.5
gen SCOREFOOT = TOTDURfootballrugbyhockeya *8
gen SCORECRICK = TOTDURcricketa *5
gen SCOREROW = TOTDURrowinga *7
gen SCORENET = TOTDURnetvolleybasketballa *5.5
gen SCOREFISH = TOTDURhuntingshootingfishinga *3
gen SCOREHORSE = TOTDURhorsebaseda *4
gen SCORESNOOK = TOTDURsnookerbillardsdartsa *2.5
gen SCOREMUSIC = TOTDURmusicalinstrumentsinginga *2.7
gen SCORESKATE = TOTDURiceskatinga *7
gen SCORESAIL = TOTDURsailingwindsurfboatinga *3
gen SCORESKI = TOTDURskiinga *7
gen SCOREBOX = TOTDURcombatssportsa*10


egen SCORELEIS = rowtotal(SCORELAPSWI SCORELESSWI SCOREBAKPAK SCOREWALKPLEASURE SCORECYCRAC SCORECYCPLE SCORELAWN SCOREWATER SCOREDIG ///
SCOREWEED SCOREDIY SCORESTEP SCOREAERO SCOREWGHT SCOREEXER SCOREFLOOR SCOREDANCE SCORECOMRUN SCOREJOG ///
SCOREBOWL SCORETENBAD SCORESQUASH SCORETABTEN SCOREGOLF SCOREFOOT SCORECRICK SCOREROW SCORENET SCOREFISH ///
SCOREHORSE SCORESNOOK SCOREMUSIC SCORESKATE SCORESAIL SCORESKI SCOREBOX)
replace SCORELEIS = . if MISSINGC == 1


/* Total score */

egen TOTMETHRS = rowtotal(SCORESLEEP SCOREHOME SCOREJOB SCORECOMMUTE SCORELEIS) if MISSING == 2
egen TOTMETHRS_w_UNACCtime = rowtotal(SCORESLEEP SCOREHOME SCOREJOB SCORECOMMUTE SCORELEIS UNACCOUNTED_MET) if MISSING == 2

gen ACTMETS = TOTMETHRS - ((TOTALtime-SLEEPtime)*1 + SLEEPtime*0.9)

/*
If UNACCOUNTED_TIME is assigned at MET=1, then ACTMETS2 is the same as ACTMETS. If we ever wish to change this, then we need to calculate ACTMETS2 as follows:
gen ACTMETS2 = TOTMETHRS_w_UNACCtime - ((24-SLEEPtime)*1 + SLEEPtime*0.9)
*/


gen HOME_METS = SCOREHOME
gen WORK_METS = SCOREJOB
gen LEIS_METS = SCORELEIS
gen COMMUTE_METS = SCORECOMMUTE

gen HOME_ACTMETS = SCOREHOME - HOMEtime
gen WORK_ACTMETS = SCOREJOB - WORKtime
gen LEIS_ACTMETS = SCORELEIS - LEIStime
gen COMMUTE_ACTMETS = SCORECOMMUTE - COMMUTEtime

* convert ACTMETS in MET.hrs/day to PAEE in kJ/day/kg
* ACTMETS is in net METhours/day
* 1 MET = 3.5 ml O2/min/kg
* 1 ml O2 = 20.35 J
* convert to METminutes (x 60) and to kJ (/ 1000)

gen PAEE         =         ACTMETS * 3.5 * 20.35 * 60 / 1000
gen HOME_PAEE    =    HOME_ACTMETS * 3.5 * 20.35 * 60 / 1000
gen WORK_PAEE    =    WORK_ACTMETS * 3.5 * 20.35 * 60 / 1000
gen LEIS_PAEE    =    LEIS_ACTMETS * 3.5 * 20.35 * 60 / 1000
gen COMMUTE_PAEE = COMMUTE_ACTMETS * 3.5 * 20.35 * 60 / 1000


*SPA: <=1.5 METs, not including sleep
egen  SED_INTENSITY = rowtotal(SCORETV SCORECAR SCOREPUBLIC SCORESITA)

*LPA: 1.5001-2.99 METs
egen LIGHT_INTENSITY = rowtotal(SCORESNOOK SCOREMUSIC SCOREPREPFOOD SCORESHOPFOOD SCORESHOPELSE SCORECLEANHSE SCORELAUNDRY ///
SCOREBABYCARE SCOREOLDCARE SCORESITB SCORESTANDA SCOREWALKA SCORESQUAT SCOREKNEEL SCOREGETUP SCOREWATER)

*MPA: 3-5.99 METs
egen MODERATE_INTENSITY = rowtotal(SCOREGETABOUTBIKE SCOREGETABOUTWALK SCOREWALKPLEASURE SCORECYCPLE SCORELAWN SCOREWEED SCOREDIY SCOREAERO SCOREWGHT SCOREEXER SCOREFLOOR ///
SCOREDANCE SCOREBOWL SCORETABTEN SCOREGOLF SCORECRICK SCORENET SCOREFISH SCOREHORSE SCORESAIL SCORELESSWI SCORETENBAD SCORESTAIRS ///
SCOREWALK SCORECYCLE SCORESTANDB SCORESTANDC SCORESTANDD SCOREWALKB SCOREJOBSTAIRS )

*VPA: >=6 METs
egen VIGOROUS_INTENSITY = rowtotal(SCORELAPSWI SCOREBAKPAK SCORECYCRAC SCOREDIG SCORESTEP SCORECOMRUN SCOREJOG SCORESQUASH SCOREFOOT SCOREROW ///
SCORESKATE SCORESKI SCOREBOX SCOREMOV SCORELADDER)

*TIME allocation by intensity

*Time spent in SPA (<=1.5 METs, not including sleep)
egen SEDtime = rowtotal(TVadj CARadj PUBLICadj DURSITAa)

*Time spent in LPA: 1.5001-2.99 METs
egen LIGHTtime = rowtotal(DURPREPFOODa DURSHOPFOODa DURSHOPELSEa DURCLEANHSEa DURLAUNDRYa ///
DURBABYCAREa DUROLDCAREa DURSITBa DURSTANDAa DURWALKAa DURSQUAT DURKNEEL DURGETUP TOTDURwaterlawna TOTDURsnookerbillardsdartsa TOTDURmusicalinstrumentsinginga)

*Time spent in MPA: 3-5.99 METs
egen MODERATEtime = rowtotal(GETABOUTBIKEadj GETABOUTWALKadj STAIRadj WALKadj CYCLEadj DURSTANDBa DURSTANDCa DURSTANDDa DURWALKBa DURSTAIRSa ///
TOTDURswimleisa TOTDURwalkpleasurea TOTDURcyclepleasurea TOTDURmowinga TOTDURweedprunea TOTDURdiya TOTDURaerobicsothera TOTDURexerciseweightsa ///
TOTDURconditionexercisea TOTDURfloorexercisea TOTDURdancinga TOTDURbowlinga TOTDURtennisbadmintona TOTDURtabletennisa TOTDURgolfa TOTDURcricketa ///
TOTDURnetvolleybasketballa TOTDURhuntingshootingfishinga TOTDURhorsebaseda TOTDURsailingwindsurfboatinga)

*Time spent in VPA: >=6 METs
egen VIGOROUStime = rowtotal( DURMOVa DURLADDERa TOTDURswimcompa TOTDURbackpackmountainclimba TOTDURcyclingracingrougha ///
TOTDURheavygardeninga TOTDURaerobicshigha TOTDURcompruna TOTDURjoga TOTDURsquasha TOTDURfootballrugbyhockeya ///
TOTDURrowinga TOTDURiceskatinga TOTDURskiinga TOTDURcombatssportsa)



*LABELLING OF KEY VARIABLES
label var WKDAYSLEEP "Average daily sleep time (hours) during the week"
label var WKENDDAYSLEEP "Average daily sleep time (hours) during the weekend" 
label var GETABOUT_bikedist "Distance (miles/wk) cycled apart from traveling to work" 
label var GETABOUT_walkdist "Distance (miles/wk) walked apart from traveling to work" 
label var DURGETABOUT_BIKE "Reported duration (hrs/day) cycled apart from traveling to work" 
label var GETABOUTBIKEadj "Scaled duration (hrs/day) cycled apart from traveling to work" 
label var DURGETABOUT_WALK "Reported duration (hrs/day) walked apart from traveling to work" 
label var GETABOUTWALKadj "Scaled duration (hrs/day) walked apart from traveling to work" 
label var DURGETABOUT "Duration (hrs/day) cycled and walked apart from traveling to work" 
label var DURTV "Reported total TV viewing time (hrs/day)" 
label var TVadj "Total TV viewing time (hrs/day), scaled for total overreporting" 
label var WALKMILES "Distance (miles/day) walked to and from work" 
label var CYCLEMILES "Distance (miles/day) cycled to and from work" 
label var CARMILES "Distance (miles/day) traveled to and from work by car" 
label var PUBLICMILES "Distance (miles/day) traveled to and from work by public transport" 
label var CARadj "Duration (hrs/day) of commuting by car, adjusted for total overreporting" 
label var PUBLICadj "Duration (hrs/day) of commuting by public transport, adj for total overreporting" 
label var CYCLEadj "Duration (hrs/day) of commuting by bike, adjusted for total overreporting" 
label var WALKadj "Duration (hrs/day) of commuting on foot, adjusted for total overreporting"
label var HOMEtime "Total duration of home domain activities (hrs/day), adj for total overreporting" 
label var WORKtime "Total duration of work domain activities (hrs/day), adj for total overreporting" 
label var DURJOB "Reported total work hours (hrs/day) averaged over a year"
label var COMMUTEtime "Total duration of commuting (hrs/day), adj for total overreporting" 
label var LEIStime "Total duration of leisure time activities (hrs/day), adj for total overreporting" 
label var UNACCOUNTED_TIME "Total time not accounted for by the PAQ (hrs/day)"
 
label var TOTMETHRS "Total reported duration (hours) of activity times intensity (MET) [METhrs/d]"
label var TOTMETHRS_w_UNACCtime  "Total reported plus unaccounted duration hours) times intensity (MET) [METhrs/d]"
label var TOTALtime "Total reported duration (hours) [hrs/d]"
label var SLEEPtime "Difference (hours) between reported bed and getting up time"
label var ACTMETS "Total activity energy expenditure discounting resting [net METhrs/d]"
label var HOME_METS "Home domain energy expenditure [METhrs/d]"
label var WORK_METS "Work domain energy expenditure [METhrs/d]"
label var LEIS_METS "Leisure domain energy expenditure [METhrs/d]"
label var COMMUTE_METS "Commute domain energy expenditure [METhrs/d]"
label var SED_INTENSITY "Sedentary behavior energy expenditure [METhrs/d]"
label var LIGHT_INTENSITY "Light intensity energy expenditure [METhrs/d]"
label var MODERATE_INTENSITY "Moderate intensity energy expenditure [METhrs/d]"
label var VIGOROUS_INTENSITY "Vigorous intensity energy expenditure [METhrs/d]"
label var SEDtime "Time spent sedentary, excluding sleep [hrs/d]"
label var LIGHTtime "Time spent at light intensity activity [hrs/d]"
label var MODERATEtime "Time spent at moderate intensity activity [hrs/d]"
label var VIGOROUStime "Time spent at vigorous intensity activity [hrs/d]"
label var leisure_missing_all_data "number of leisure activities missing all data (max. 35)"
label var leisure_missing_freq "number of leisure activities missing frequency data (max. 35)"
label var leisure_missing_duration "number of leisure activities missing duration data (max. 35)"

label var PAEE "Total PAEE calculated from self-report ACTMETS (kJ/day/kg)"
label var HOME_PAEE "Home domain PAEE calculated from self-report ACTMETS (kJ/day/kg)"
label var WORK_PAEE "Work domain PAEE calculated from self-report ACTMETS (kJ/day/kg)"
label var LEIS_PAEE "Leisure domain PAEE calculated from self-report ACTMETS (kJ/day/kg)"
label var COMMUTE_PAEE "Commuting PAEE calculated from self-report ACTMETS (kJ/day/kg)"


***************************
*END
***************************

keep *id WKDAYSLEEP WKENDDAYSLEEP GETABOUT_bikedist GETABOUT_walkdist DURGETABOUT_BIKE DURGETABOUT_WALK GETABOUTBIKEadj GETABOUTWALKadj DURGETABOUT DURTV TVadj WALKMILES CYCLEMILES CARMILES PUBLICMILES CARadj PUBLICadj CYCLEadj WALKadj HOMEtime WORKtime DURJOB COMMUTEtime LEIStime UNACCOUNTED_TIME TOTMETHRS TOTMETHRS_w_UNACCtime TOTALtime ACTMETS SED_INTENSITY LIGHT_INTENSITY MODERATE_INTENSITY VIGOROUS_INTENSITY SLEEPtime SEDtime LIGHTtime MODERATEtime VIGOROUStime HOME_METS WORK_METS LEIS_METS COMMUTE_METS leisure_missing_all_data leisure_missing_freq leisure_missing_duration activities_done PAEE HOME_PAEE WORK_PAEE LEIS_PAEE COMMUTE_PAE
order *id WKDAYSLEEP WKENDDAYSLEEP GETABOUT_bikedist GETABOUT_walkdist DURGETABOUT_BIKE DURGETABOUT_WALK GETABOUTBIKEadj GETABOUTWALKadj DURGETABOUT DURTV TVadj WALKMILES CYCLEMILES CARMILES PUBLICMILES CARadj PUBLICadj CYCLEadj WALKadj HOMEtime WORKtime DURJOB COMMUTEtime LEIStime UNACCOUNTED_TIME TOTMETHRS TOTMETHRS_w_UNACCtime TOTALtime ACTMETS SED_INTENSITY LIGHT_INTENSITY MODERATE_INTENSITY VIGOROUS_INTENSITY SLEEPtime SEDtime LIGHTtime MODERATEtime VIGOROUStime HOME_METS WORK_METS LEIS_METS COMMUTE_METS leisure_missing_all_data leisure_missing_freq leisure_missing_duration activities_done PAEE HOME_PAEE WORK_PAEE LEIS_PAEE COMMUTE_PAE


cd "`FOLDER'"
save `OUTPUT_FILE', replace
*This is now the most up to date version of EPAQ2 data with METs generated that is to be used for analyses.
