**************************************************************************************************************************************
*This syntax applies to data entered using the data entry guideline document titled: "SIT-Q-7d_Data_Entry.doc",
*following preliminary cleaning using the "1_Prim_clean_SIT-Q-7d_Generic.do" file.
*	  Authors: Katrien Wijndaele & Kate Westgate																										*
*	  Version = "v2.0 - 25/07/2013"
*********************************************************************************************************************************	

local FOLDER = "V:\P5_PhysAct\"
*DEFINE HERE TEST OR RETEST
local TESTNAME = " " /*Test or Retest*/

local INPUT_FILE = "DRCT_Q4_Test" /*same as do.file 1 (now .DTA format) */
local OUTPUT_FILE = "DRCT_Q4_`TESTNAME'_secondary_cleaned.dta"

local ADDITIONAL_DO_FILE = "Additional_studyspecific_cleaning_SIT-Q-7d.do" /*NAME OF ADDITIONAL .DO FILE FOR STUDY SPECIFIC CLEANING*/
***************************************************************************************************************************************
use "`FOLDER'/`INPUT_FILE'_primary_cleaned.dta", clear
set more off

***SECTION 1 - SLEEPING & NAPPING***
recode dA1_1_go_sle_wd_hr dA1_1_go_sle_wd_min dA1_2_get_up_wd_hr dA1_2_get_up_wd_min/*
*/ dA1_3_go_sle_wndd_hr dA1_3_go_sle_wndd_min dA1_4_get_up_wndd_hr dA1_4_get_up_wndd_min/*
*/(-1=.)

recode dA2_1_dur_nap_wd dA2_2_dur_nap_wndd/* recoding mins to mid-point of range
*/(-1=.) (1=0) (2=7.5) (3=22.5) (4=37.5) (5=52.5) (6=67.5)

***SECTION 2***
recode dB3_1_dur_meal_wd_br dB3_2_dur_meal_wd_lu dB3_3_dur_meal_wd_di dB3_4_dur_meal_wndd_br dB3_5_dur_meal_wndd_lu dB3_6_dur_meal_wndd_di/* recoding mins to mid-point of range
*/(-1=.) (1=0) (2=5) (3=15) (4=25) (5=37.5) (6=52.5)(7=67.5)

***SECTION 4***

foreach var of varlist dD13a_freq_occ1 dD13b_freq_occ2{
replace `var' = . if `var'==-1 | `var'>=7.1/*recode to missing if no entry or >7days reported*/
}

recode dD14a_dur_occ1 dD14b_dur_occ2/*
*/(-1=.) (1=0) (2=7.5) (3=22.5) (4=45) (5=90) (6=150) (7=210) (8=270) (9=330) (10=390) (11=450) (12=510) /* recoding mins to mid-point of range*/

replace dD13a_freq_occ1 =0  if dD13a_freq_occ1 ==. & dD14a_dur_occ1==0
replace dD14a_dur_occ1  =0  if dD14a_dur_occ1 ==. & dD13a_freq_occ1==0
replace dD13b_freq_occ2 =0  if dD13b_freq_occ2 ==. & dD14b_dur_occ2==0
replace dD14b_dur_occ2  =0  if dD14b_dur_occ2 ==. & dD13b_freq_occ2==0

recode dD15a_freq_break_occ1 dD15b_freq_break_occ2 (-1=.)

*Cleaning dD10_status_occ (2= having occupation, 3 = not having occupation)
replace dD10_status_occ=2 if dD13a_freq_occ1>0 & (dD13a_freq_occ1!=. & dD14a_dur_occ1!=.)
replace dD10_status_occ=3 if dD13a_freq_occ1==0 & (dD13a_freq_occ1!=. & dD14a_dur_occ1!=.) & dD14a_dur_occ1!=0 
recode dD10_status_occ (-1=3) 

replace dD16_status_occ2=2 if dD13b_freq_occ2>0 & dD13b_freq_occ2!=. 
replace dD16_status_occ2=3 if dD13b_freq_occ2==0 & (dD13b_freq_occ2!=. & dD14b_dur_occ2!=.) & dD14b_dur_occ2!=0
recode dD16_status_occ2 (-1=3) if dD13b_freq_occ2==. & dD10_status_occ==2
recode dD16_status_occ2 (-1=3) if dD10_status_occ==3
recode dD16_status_occ2 (2=3) if dD10_status_occ==3

tab1 dD13a_freq_occ1 dD14a_dur_occ1 dD15a_freq_break_occ1 if dD10_status_occ==2
tab1 dD13b_freq_occ2 dD14b_dur_occ2 dD15b_freq_break_occ2 if dD16_status_occ2==2

*Cleaning type of occupation
recode dD11a_type_occ1 dD11b_type_occ2 (-1=.)

***SECTION 3***
*Transport to & from occupation: 

foreach var of varlist dC5_1_freq_to_from_occ1 dC5_2_freq_to_from_occ2 dC7_1_freq_part_of_occ1 dC7_2_freq_part_of_occ2{
replace `var' = . if `var'==-1 | `var'>=7.1 /*recode to missing if no entry or >7days reported*/
}

foreach var of varlist dC5_1_freq_to_from_occ1 dC6_1_dur_to_from_occ1 dC7_1_freq_part_of_occ1 dC8_1_dur_part_of_occ1{
replace `var'=. if dD10_status_occ==3 /*recode to missing if no occupation reported*/
}

foreach var of varlist dC5_2_freq_to_from_occ2 dC6_2_dur_to_from_occ2 dC7_2_freq_part_of_occ2 dC8_2_dur_part_of_occ2 {
replace `var'=. if dD16_status_occ2==3
}

recode dC6_1_dur_to_from_occ1 dC6_2_dur_to_from_occ2 dC8_1_dur_part_of_occ1 dC8_2_dur_part_of_occ2 dC9_1_dur_apart_from_wd dC9_2_dur_apart_from_wndd/*
*/(-1=.) (1=0) (2=7.5) (3=22.5) (4=37.5) (5=52.5) (6=75) (7=105) (8=135) (9=165) (10=210) (11=270) (12=330) (13=390) (14=450)        

recode dC5_1_freq_to_from_occ1 (.=0) if (dD10_status_occ==2 & dC5_1_freq_to_from_occ1==.) & dC6_1_dur_to_from_occ1==0
recode dC6_1_dur_to_from_occ1  (.=0) if (dD10_status_occ==2 & dC6_1_dur_to_from_occ1==.) & dC5_1_freq_to_from_occ1==0

recode dC5_2_freq_to_from_occ2 (.=0) if (dD16_status_occ2==2 & dC5_2_freq_to_from_occ2==.) & dC6_2_dur_to_from_occ2==0
recode dC6_2_dur_to_from_occ2  (.=0) if (dD16_status_occ2==2 & dC6_2_dur_to_from_occ2==.) & dC5_2_freq_to_from_occ2==0

recode dC7_1_freq_part_of_occ1 (.=0) if (dD10_status_occ==2 & dC7_1_freq_part_of_occ1==.) & dC8_1_dur_part_of_occ1==0
recode dC8_1_dur_part_of_occ1  (.=0) if (dD10_status_occ==2 & dC8_1_dur_part_of_occ1==.) & dC7_1_freq_part_of_occ1==0

recode dC7_2_freq_part_of_occ2 (.=0) if (dD16_status_occ2==2 & dC7_2_freq_part_of_occ2==.) & dC8_2_dur_part_of_occ2==0
recode dC8_2_dur_part_of_occ2  (.=0) if (dD16_status_occ2==2 & dC8_2_dur_part_of_occ2==.) & dC7_2_freq_part_of_occ2==0

tab1 dC5_1_freq_to_from_occ1 dC6_1_dur_to_from_occ1 dC7_1_freq_part_of_occ1 dC8_1_dur_part_of_occ1 if dD10_status_occ==2
tab1 dC5_2_freq_to_from_occ2 dC6_2_dur_to_from_occ2 dC7_2_freq_part_of_occ2 dC8_2_dur_part_of_occ2 if dD16_status_occ2==2


***SECTION 5***
*Screen time & other activities
recode dE17_1_dur_tv_wd dE17_2_dur_tv_wndd dE17_3_dur_comp_wd dE17_4_dur_comp_wndd dE17_5_dur_game_wd dE17_6_dur_game_wndd /*screen time variables
*/dE20_1_dur_read_wd dE20_2_dur_read_wndd dE20_3_dur_house_wd dE20_4_dur_house_wndd dE20_5_dur_cari_wd dE20_6_dur_cari_wndd /*other activities
*/dE20_7_dur_hobb_wd dE20_8_dur_hobb_wndd dE20_9_dur_soc_wd dE20_10_dur_soc_wndd dE20_11_dur_music_wd dE20_12_dur_music_wndd /*
*/dE20_14_dur_other_wd dE20_15_dur_other_wndd/*
*/(-1=.) (1=0) (2=7.5) (3=22.5) (4=45) (5=90) (6=150) (7=210) (8=270) (9=330) (10=390) (11=450)    

*Break up TV viewing time (absolute number): 
recode dE18_freq_break_tv (-1=.)

*FFQ: recode into times per day: 
recode dE19_1_freq_savor dE19_2_freq_sweet dE19_3_freq_ice dE19_4_freq_yoghurt dE19_5_freq_soda dE19_6_freq_frjuice /*
*/dE19_7_freq_squash dE19_8_freq_milk dE19_9_freq_tea dE19_10_freq_alcoh dE19_12_freq_other/*
*/(-1=.) (1=0) (2=0.21) (3=0.5) (4=0.79) (5=1) (6=2) (7=3) (8=4) (9=5) (10=6)  /* recoding frequency to mid-point of range (* per day)*/
  
foreach var of varlist dE19_1_freq_savor dE19_2_freq_sweet dE19_3_freq_ice dE19_4_freq_yoghurt dE19_5_freq_soda dE19_6_freq_frjuice /*
*/dE19_7_freq_squash dE19_8_freq_milk dE19_9_freq_tea dE19_10_freq_alcoh dE19_12_freq_other  {
replace `var' = . if (dE17_1_dur_tv_wd==. & dE17_2_dur_tv_wndd==.) | (dE17_1_dur_tv_wd==. & dE17_2_dur_tv_wndd==0)/*
*/| (dE17_1_dur_tv_wd==0 & dE17_2_dur_tv_wndd==. )| (dE17_1_dur_tv_wd==0 & dE17_2_dur_tv_wndd==0)
}

*Summarising frequencies
tab1 d_repres_typ_w dA1_1_go_sle_wd_hr dA1_1_go_sle_wd_min dA1_2_get_up_wd_hr dA1_2_get_up_wd_min /*
*/dA1_3_go_sle_wndd_hr dA1_3_go_sle_wndd_min dA1_4_get_up_wndd_hr dA1_4_get_up_wndd_min dA2_1_dur_nap_wd dA2_2_dur_nap_wndd /*
*/dB3_1_dur_meal_wd_br dB3_2_dur_meal_wd_lu dB3_3_dur_meal_wd_di dB3_4_dur_meal_wndd_br dB3_5_dur_meal_wndd_lu dB3_6_dur_meal_wndd_di /*
*/dC9_1_dur_apart_from_wd dC9_2_dur_apart_from_wndd dE17_1_dur_tv_wd dE17_2_dur_tv_wndd dE17_3_dur_comp_wd dE17_4_dur_comp_wndd /*
*/dE17_5_dur_game_wd dE17_6_dur_game_wndd dE18_freq_break_tv dE19_1_freq_savor dE19_2_freq_sweet dE19_3_freq_ice dE19_4_freq_yoghurt /*
*/dE19_5_freq_soda dE19_6_freq_frjuice dE19_7_freq_squash dE19_8_freq_milk dE19_9_freq_tea dE19_10_freq_alcoh dE19_11_name_other dE19_12_freq_other /*
*/dE20_1_dur_read_wd dE20_2_dur_read_wndd dE20_3_dur_house_wd dE20_4_dur_house_wndd dE20_5_dur_cari_wd dE20_6_dur_cari_wndd dE20_7_dur_hobb_wd /*
*/dE20_8_dur_hobb_wndd dE20_9_dur_soc_wd dE20_10_dur_soc_wndd dE20_11_dur_music_wd dE20_12_dur_music_wndd dE20_14_dur_other_wd /*
*/dE20_15_dur_other_wndd

tab1 dD13a_freq_occ1 dD14a_dur_occ1 dD15a_freq_break_occ1 dD11a_type_occ1 dC5_1_freq_to_from_occ1 dC6_1_dur_to_from_occ1 dC7_1_freq_part_of_occ1 dC8_1_dur_part_of_occ1 if dD10_status_occ==2
tab1 dD13b_freq_occ2 dD14b_dur_occ2 dD15b_freq_break_occ2 dD11b_type_occ2 dC5_2_freq_to_from_occ2 dC6_2_dur_to_from_occ2 dC7_2_freq_part_of_occ2 dC8_2_dur_part_of_occ2  if dD16_status_occ2==2

rename Diabetes_Questionnaire* Diabetes_Quest*
rename * *_c  /* just renaming _c to denote variables cleaned (to mimic previous SPSS code structure)*/
rename StudyID_c StudyID


*B) CALCULATING SUMMARY VARIABLES:

*SECTION 1: 
*------------------
*- Average day sleep duration (napping not included):
*- Hours:
gen go_sle_wd_time_dec = dA1_1_go_sle_wd_hr_c + (dA1_1_go_sle_wd_min_c/60)/*calculate the times as a decimals*/
gen get_up_wd_time_dec = dA1_2_get_up_wd_hr_c + (dA1_2_get_up_wd_min_c/60)
gen go_sle_wndd_time_dec = dA1_3_go_sle_wndd_hr_c + (dA1_3_go_sle_wndd_min_c/60)
gen get_up_wndd_time_dec = dA1_4_get_up_wndd_hr_c + (dA1_4_get_up_wndd_min_c/60)

gen wd_dur_sleep_dec=./*Calculating durations of sleep*/
replace wd_dur_sleep_dec=(24-go_sle_wd_time_dec) + get_up_wd_time_dec if (go_sle_wd_time_dec>=get_up_wd_time_dec & go_sle_wd_time_dec>=12)|(go_sle_wd_time_dec>=get_up_wd_time_dec & go_sle_wd_time_dec<12)
replace wd_dur_sleep_dec=get_up_wd_time_dec - go_sle_wd_time_dec if (go_sle_wd_time_dec<get_up_wd_time_dec & go_sle_wd_time_dec<12)|(go_sle_wd_time_dec<get_up_wd_time_dec & go_sle_wd_time_dec>12)
gen wndd_dur_sleep_dec=.
replace wndd_dur_sleep_dec=(24-go_sle_wndd_time_dec) + get_up_wndd_time_dec if (go_sle_wndd_time_dec>=get_up_wndd_time_dec & go_sle_wndd_time_dec>=12)|(go_sle_wndd_time_dec>=get_up_wndd_time_dec & go_sle_wndd_time_dec<12)
replace wndd_dur_sleep_dec=get_up_wndd_time_dec - go_sle_wndd_time_dec if (go_sle_wndd_time_dec<get_up_wndd_time_dec & go_sle_wndd_time_dec<12)|(go_sle_wndd_time_dec<get_up_wndd_time_dec & go_sle_wndd_time_dec>12)

replace wd_dur_sleep_dec =. if wd_dur_sleep_dec<=3 |  wd_dur_sleep_dec>=14
replace wndd_dur_sleep_dec =. if wndd_dur_sleep_dec<=3 |  wndd_dur_sleep_dec>=14

gen tot_dur_sleep_day_hrs=((5*wd_dur_sleep_dec) + (2*wndd_dur_sleep_dec))/7.
replace tot_dur_sleep_day_hrs = wd_dur_sleep_dec if wndd_dur_sleep_dec==.

*- Minutes: 
gen tot_dur_sleep_day=tot_dur_sleep_day_hrs*60.

*---> Napping:
gen tot_dur_nap_day=((5*dA2_1_dur_nap_wd_c) + (2*dA2_2_dur_nap_wndd_c))/7.
replace tot_dur_nap_day = dA2_1_dur_nap_wd_c if dA2_2_dur_nap_wndd_c==.
*if only have a weekend day reported, leave as missing.
gen tot_dur_nap_day_hrs=tot_dur_nap_day/60.

*---> Average day sleep duration including napping:
egen tot_dur_sleep_nap_day=rowtotal(tot_dur_sleep_day tot_dur_nap_day) if tot_dur_sleep_day!=.

*---> Weekday sleep duration including napping:
gen wd_dur_sleep_dec_temp = wd_dur_sleep_dec*60
egen tot_dur_sleep_nap_wd=rowtotal(wd_dur_sleep_dec_temp dA2_1_dur_nap_wd_c) if wd_dur_sleep_dec!=.
drop wd_dur_sleep_dec_temp
*---> Weekendday sleep duration including napping:
gen wndd_dur_sleep_dec_temp = wndd_dur_sleep_dec*60
egen tot_dur_sleep_nap_wndd=rowtotal(wndd_dur_sleep_dec_temp dA2_2_dur_nap_wndd_c) if wndd_dur_sleep_dec!=.
drop wndd_dur_sleep_dec_temp


*SECTION 2: 
*------------------
*---> Weekday:
egen tot_dur_meal_wd=rowtotal(dB3_1_dur_meal_wd_br_c dB3_2_dur_meal_wd_lu_c dB3_3_dur_meal_wd_di_c) if dB3_3_dur_meal_wd_di_c!=.

*---> Weekendday:
egen tot_dur_meal_wndd=rowtotal(dB3_4_dur_meal_wndd_br_c dB3_5_dur_meal_wndd_lu_c dB3_6_dur_meal_wndd_di_c) if dB3_6_dur_meal_wndd_di_c!=.

*---> Average day:
gen tot_dur_meal_day=((5*tot_dur_meal_wd) + (2*tot_dur_meal_wndd))/7

replace tot_dur_meal_day = tot_dur_meal_wd if tot_dur_meal_wndd==.
*if only have a weekend day reported, leave as missing.


*SECTION 4: 
*------------------
*---> Sedentary occupational time, average day: 
gen tot_dur_occ_1=dD13a_freq_occ1_c*dD14a_dur_occ1_c
gen tot_dur_occ_2=dD13b_freq_occ2_c*dD14b_dur_occ2_c
egen tot_dur_occ_day=rowtotal(tot_dur_occ_1 tot_dur_occ_2)if dD10_status_occ == 2 & (tot_dur_occ_1!=. | tot_dur_occ_2!=.)
replace tot_dur_occ_day=tot_dur_occ_day/7 if dD10_status_occ == 2 
drop tot_dur_occ_1 tot_dur_occ_2

*---> Average number of breaks per hour of occupational time:
*- Occupation 1: 
gen aver_break_occ1_hour=(dD15a_freq_break_occ1_c / (dD14a_dur_occ1_c/60)) if dD14a_dur_occ1_c > 0 & dD10_status_occ_c==2
tab1 aver_break_occ1_hour if dD10_status_occ_c==2 & dD14a_dur_occ1_c > 0

*- Occupation 2: 
gen aver_break_occ2_hour=(dD15b_freq_break_occ2_c / (dD14b_dur_occ2_c/60)) if dD14b_dur_occ2_c > 0 & dD16_status_occ2_c==2
tab1 aver_break_occ2_hour if dD16_status_occ2_c==2 & dD14b_dur_occ2_c > 0

*- Average:
gen val_aver_break_occ= !mi(aver_break_occ1_hour) + !mi(aver_break_occ2_hour)  /* determines whether 1 or 2 occupations were used for calcuating breaks variable*/
egen aver_break_occ_hour=rowtotal(aver_break_occ1_hour aver_break_occ2_hour) if aver_break_occ1_hour!=. | aver_break_occ2_hour!=. & (dD10_status_occ_c==2 & (dD14a_dur_occ1_c > 0 | dD14b_dur_occ2_c > 0))
replace aver_break_occ_hour= aver_break_occ_hour/val_aver_break_occ 
tab1 aver_break_occ_hour if dD10_status_occ==2 & (dD14a_dur_occ1 > 0 | dD14b_dur_occ2 > 0)
drop val_aver_break_occ


*SECTION 3: 
*------------------
*---> Sedentary time transportation, average day: 
*- To and from occupation:
gen dur_to_from_occ1 = dC5_1_freq_to_from_occ1_c*dC6_1_dur_to_from_occ1_c
gen dur_to_from_occ2 = dC5_2_freq_to_from_occ2_c*dC6_2_dur_to_from_occ2_c
egen tot_dur_to_from_occ_day=rowtotal(dur_to_from_occ1 dur_to_from_occ2) if dD10_status_occ_c==2 & (dur_to_from_occ1!=. | dur_to_from_occ2!=.)
replace tot_dur_to_from_occ_day = tot_dur_to_from_occ_day/7 if dD10_status_occ_c==2
drop dur_to_from_occ1 dur_to_from_occ2

*- Part of occupation:
gen tot_dur_part_of_occ_day1 = dC7_1_freq_part_of_occ1_c*dC8_1_dur_part_of_occ1_c
gen tot_dur_part_of_occ_day2 = dC7_2_freq_part_of_occ2_c*dC8_2_dur_part_of_occ2_c
egen tot_dur_part_of_occ_day=rowtotal(tot_dur_part_of_occ_day1 tot_dur_part_of_occ_day2) if dD10_status_occ_c==2 & (tot_dur_part_of_occ_day1!=. | tot_dur_part_of_occ_day2!=.)
replace tot_dur_part_of_occ_day=tot_dur_part_of_occ_day/7
drop tot_dur_part_of_occ_day1 tot_dur_part_of_occ_day2

*-There are a lot of missings for "travelling as part of your occupation" and this is probably not a higly prevalent behaviour, so first calculate an occupational sedentary transportation variable
* using the SUM command:
egen tot_dur_transp_occ_day=rowtotal(tot_dur_to_from_occ_day tot_dur_part_of_occ_day) if dD10_status_occ_c==2 & (tot_dur_to_from_occ_day!=. | tot_dur_part_of_occ_day!=.)
tab1 tot_dur_to_from_occ_day tot_dur_part_of_occ_day tot_dur_transp_occ_day if dD10_status_occ_c==2

*- Apart from occupation:
*There are a lot of missings for weekend (probably because of change in format in questionnaire going from question 8 to question 9), so will use SUM command (although is maybe a bit too liberal...):			
gen weighted_dC9_1_dur_apart_wd=(5*dC9_1_dur_apart_from_wd_c)/7.
gen weighted_dC9_2_dur_apart_wndd=(2*dC9_2_dur_apart_from_wndd_c)/7.
egen tot_dur_apart_from_day=rowtotal(weighted_dC9_1_dur_apart_wd weighted_dC9_2_dur_apart_wndd) if weighted_dC9_1_dur_apart_wd!=. | weighted_dC9_2_dur_apart_wndd!=.

*- Total sedentary transportation, average day: 
   *Participants with and without job should be treated equally in terms of chance for missingness
egen tot_dur_transp_day=rowtotal(tot_dur_transp_occ_day tot_dur_apart_from_day) if dD10_status_occ_c == 2 & (tot_dur_transp_occ_day!=. | tot_dur_apart_from_day!=.)
replace tot_dur_transp_day = tot_dur_apart_from_day if dD10_status_occ_c==3

drop weighted_dC9_1_dur_apart_wd weighted_dC9_2_dur_apart_wndd

*SECTION 5 
*------------------
*---> TV viewing average day:
gen tot_dur_tv_day=((5*dE17_1_dur_tv_wd_c) + (2*dE17_2_dur_tv_wndd_c))/7.
*---> Computer (not work related) average day:
gen tot_dur_comp_day=((5*dE17_3_dur_comp_wd_c) + (2*dE17_4_dur_comp_wndd_c))/7.
*---> Sedentary computer games average day:
gen tot_dur_game_day=((5*dE17_5_dur_game_wd_c) + (2*dE17_6_dur_game_wndd_c))/7.
*---> Computer and sedentary computer games: 
*- Weekday:
   *Because there were several more missings for sedentary computer games, and this is not a highly prevalent behaviour, calculate this with SUM command:
egen tot_dur_comp_game_wd=rowtotal(dE17_3_dur_comp_wd_c dE17_5_dur_game_wd_c) if dE17_3_dur_comp_wd_c!=. | dE17_5_dur_game_wd_c!=.
*- Weekend day:
egen tot_dur_comp_game_wndd=rowtotal(dE17_4_dur_comp_wndd_c dE17_6_dur_game_wndd_c) if dE17_4_dur_comp_wndd_c!=. | dE17_6_dur_game_wndd_c!=.
*- Average day:
gen tot_dur_comp_game_day=((5*tot_dur_comp_game_wd) + (2*tot_dur_comp_game_wndd))/7.

*---> Total sceen time:
*- Weekday:
egen tot_dur_screen_wd=rowtotal(dE17_1_dur_tv_wd_c tot_dur_comp_game_wd) if dE17_1_dur_tv_wd_c!=. | tot_dur_comp_game_wd!=.
*- Weekend day:
egen tot_dur_screen_wndd=rowtotal(dE17_2_dur_tv_wndd_c tot_dur_comp_game_wndd) if dE17_2_dur_tv_wndd_c!=. | tot_dur_comp_game_wndd!=.
*- Average day:
gen tot_dur_sceen_day=((5*tot_dur_screen_wd) + (2*tot_dur_screen_wndd))/7.

*---> Average number of breaks per hour of tv viewing time:
gen aver_break_tv_hour=(dE18_freq_break_tv_c / (tot_dur_tv_day/60)) if (tot_dur_tv_day > 0)
tab1 aver_break_tv_hour if tot_dur_tv_day > 0
  
*---> Snacking will not be summarized here

*---> Other activities:
*- Different activities average day (only report on other sedentary activities if at least three items are reported for weekdays and for weekend days):
gen weighted_dE20_1_dur_read_wd_c=(5*dE20_1_dur_read_wd_c)/7
gen weighted_dE20_2_dur_read_wndd_c=(2*dE20_2_dur_read_wndd_c)/7
egen tot_dur_read_day=rowtotal(weighted_dE20_1_dur_read_wd_c weighted_dE20_2_dur_read_wndd_c) if weighted_dE20_1_dur_read_wd_c!=. | weighted_dE20_2_dur_read_wndd_c!=.

gen weighted_dE20_3_dur_house_wd_c=(5*dE20_3_dur_house_wd_c)/7
gen weighted_dE20_4_dur_house_wndd_c=(2*dE20_4_dur_house_wndd_c)/7
egen tot_dur_house_day=rowtotal(weighted_dE20_3_dur_house_wd_c weighted_dE20_4_dur_house_wndd_c) if weighted_dE20_3_dur_house_wd_c!=. | weighted_dE20_4_dur_house_wndd_c!=.

gen weighted_dE20_5_dur_cari_wd_c=(5*dE20_5_dur_cari_wd_c)/7
gen weighted_dE20_6_dur_cari_wndd_c=(2*dE20_6_dur_cari_wndd_c)/7
egen tot_dur_cari_day=rowtotal(weighted_dE20_5_dur_cari_wd_c weighted_dE20_6_dur_cari_wndd_c) if weighted_dE20_5_dur_cari_wd_c!=. | weighted_dE20_6_dur_cari_wndd_c!=.

gen weighted_dE20_7_dur_hobb_wd_c=(5*dE20_7_dur_hobb_wd_c)/7
gen weighted_dE20_8_dur_hobb_wndd_c=(2*dE20_8_dur_hobb_wndd_c)/7
egen tot_dur_hobb_day=rowtotal(weighted_dE20_7_dur_hobb_wd_c weighted_dE20_8_dur_hobb_wndd_c) if weighted_dE20_7_dur_hobb_wd_c!=. | weighted_dE20_8_dur_hobb_wndd_c!=.

gen weighted_dE20_9_dur_soc_wd_c=(5*dE20_9_dur_soc_wd_c)/7
gen weighted_dE20_10_dur_soc_wndd_c=(2*dE20_10_dur_soc_wndd_c)/7
egen tot_dur_soc_day=rowtotal(weighted_dE20_9_dur_soc_wd_c weighted_dE20_10_dur_soc_wndd_c) if weighted_dE20_9_dur_soc_wd_c!=. | weighted_dE20_10_dur_soc_wndd_c!=.

gen weight_dE20_11_dur_music_wd_c=(5*dE20_11_dur_music_wd_c)/7
gen weight_dE20_12_dur_music_wndd_c=(2*dE20_12_dur_music_wndd_c)/7
egen tot_dur_music_day=rowtotal(weight_dE20_11_dur_music_wd_c weight_dE20_12_dur_music_wndd_c) if weight_dE20_11_dur_music_wd_c!=. | weight_dE20_12_dur_music_wndd_c!=.

gen weight_dE20_14_dur_other_wd_c=(5*dE20_14_dur_other_wd_c)/7
gen weight_dE20_15_dur_other_wndd_c=(2*dE20_15_dur_other_wndd_c)/7

egen tot_dur_other_day=rowtotal(weight_dE20_14_dur_other_wd weight_dE20_15_dur_other_wndd) if weight_dE20_14_dur_other_wd!=. | weight_dE20_15_dur_other_wndd!=.

*---> Total other sedentary time: 

*- Weekday:
gen missing_wk_sed = !mi(dE20_1_dur_read_wd_c) + !mi(dE20_3_dur_house_wd_c)+!mi(dE20_5_dur_cari_wd_c)+!mi(dE20_7_dur_hobb_wd_c) +!mi(dE20_9_dur_soc_wd_c) +!mi(dE20_11_dur_music_wd_c)
egen tot_dur_other_sed_wd=rowtotal(dE20_1_dur_read_wd_c dE20_3_dur_house_wd_c dE20_5_dur_cari_wd_c dE20_7_dur_hobb_wd_c dE20_9_dur_soc_wd_c /*
*/dE20_11_dur_music_wd_c dE20_14_dur_other_wd_c) if missing_wk_sed >= 3

*- Weekend day:
gen missing_wkend_sed = !mi(dE20_2_dur_read_wndd_c) + !mi(dE20_4_dur_house_wndd_c)+!mi(dE20_6_dur_cari_wndd_c)+!mi(dE20_8_dur_hobb_wndd_c) +!mi(dE20_10_dur_soc_wndd_c) +!mi(dE20_12_dur_music_wndd_c)
egen tot_dur_other_sed_wndd=rowtotal(dE20_2_dur_read_wndd_c dE20_4_dur_house_wndd_c dE20_6_dur_cari_wndd_c dE20_8_dur_hobb_wndd_c /*
*/dE20_10_dur_soc_wndd_c dE20_12_dur_music_wndd_c dE20_15_dur_other_wndd_c) if missing_wkend_sed >= 3

drop missing_wk_sed missing_wkend_sed

*- Average day:
gen tot_dur_other_sed_day=((5*tot_dur_other_sed_wd) + (2*tot_dur_other_sed_wndd))/7.

drop weighted_dE20_1_dur_read_wd_c weighted_dE20_2_dur_read_wndd_c weighted_dE20_3_dur_house_wd_c weighted_dE20_4_dur_house_wndd_c /*
*/weighted_dE20_5_dur_cari_wd_c weighted_dE20_6_dur_cari_wndd_c weighted_dE20_7_dur_hobb_wd_c weighted_dE20_8_dur_hobb_wndd_c weighted_dE20_9_dur_soc_wd_c /*
*/weighted_dE20_10_dur_soc_wndd_c weight_dE20_11_dur_music_wd_c weight_dE20_12_dur_music_wndd_c weight_dE20_14_dur_other_wd_c weight_dE20_15_dur_other_wndd_c
 
*For overview table:
tab1 tot_dur_sleep_day_hrs tot_dur_nap_day_hrs tot_dur_sleep_nap_day /*
*/    tot_dur_meal_day tot_dur_apart_from_day tot_dur_transp_day tot_dur_sceen_day tot_dur_tv_day /*
*/    tot_dur_comp_game_day tot_dur_other_sed_day tot_dur_sleep_nap_wd tot_dur_meal_wd tot_dur_screen_wd /* 
*/   dE17_1_dur_tv_wd_c tot_dur_comp_game_wd tot_dur_other_sed_wd tot_dur_sleep_nap_wndd /* 
*/  tot_dur_meal_wndd tot_dur_screen_wndd dE17_2_dur_tv_wndd_c tot_dur_comp_game_wndd tot_dur_other_sed_wndd

tab1 tot_dur_transp_occ_day tot_dur_occ_day if dD10_status_occ_c== 2


*TOTAL SEDENTARY TIME:
*----------------------------------------
/*
*Duration variables: 
- Average day sleep duration (napping not included) MIN: tot_dur_sleep_day
- Average day sleep duration including napping MIN: tot_dur_sleep_nap_day
- Average day sedentary meal duration MIN: tot_dur_meal_day
- Average day sedentary occupational time (IF D10_status_occ_c = 2) MIN: tot_dur_occ_day
- Average day sedentary transportation MIN: tot_dur_transp_day
- Average day TV viewing MIN: tot_dur_tv_day
- Average day computer (not work related) MIN: tot_dur_comp_day
- Average day sedentary computer games MIN: tot_dur_game_day
- Average day computer and sedentary computer games MIN: tot_dur_comp_game_day
- Average day total screen time MIN: tot_dur_sceen_day
- Average day total other sedentary time MIN: tot_dur_other_sed_day

*Breaking up variables:
- Average number of breaks per hour of tv viewing time (IF tot_dur_tv_day > 0) NUMBER: aver_break_tv_hour
- Average number of breaks per hour of occupational time (IF (dD10_status_occ_c = 2) AND (tot_dur_occ_day > 0)) NUMBER: aver_break_occ_hour

*/
*---> Total sedentary time average day (MIN):
gen tot_dur_sed_day_a=(tot_dur_sleep_nap_day + tot_dur_meal_day + tot_dur_occ_day + tot_dur_transp_day + tot_dur_sceen_day + tot_dur_other_sed_day) if dD10_status_occ_c == 2 
gen tot_dur_sed_day_b=(tot_dur_sleep_nap_day + tot_dur_meal_day + tot_dur_transp_day + tot_dur_sceen_day + tot_dur_other_sed_day) if dD10_status_occ_c == 3 
gen tot_dur_sed_day = tot_dur_sed_day_a
replace tot_dur_sed_day = tot_dur_sed_day_b if dD10_status_occ_c==3

gen tot_dur_sed_nosleep_day_a=(tot_dur_meal_day + tot_dur_occ_day + tot_dur_transp_day + tot_dur_sceen_day + tot_dur_other_sed_day) if dD10_status_occ_c==2
gen tot_dur_sed_nosleep_day_b=(tot_dur_meal_day + tot_dur_transp_day + tot_dur_sceen_day + tot_dur_other_sed_day) if dD10_status_occ_c==3
gen tot_dur_sed_nosleep_day= tot_dur_sed_nosleep_day_a
replace tot_dur_sed_nosleep_day=tot_dur_sed_nosleep_day_b if dD10_status_occ_c==3

*---> Get all summary variables in hours/day:
gen tot_dur_sleep_day_h=tot_dur_sleep_day/60
gen tot_dur_sleep_nap_day_h=tot_dur_sleep_nap_day/60
gen tot_dur_meal_day_h=tot_dur_meal_day/60
gen tot_dur_transp_day_h=tot_dur_transp_day/60
gen tot_dur_occ_day_h=tot_dur_occ_day/60
gen tot_dur_tv_day_h=tot_dur_tv_day/60
gen tot_dur_comp_day_h=tot_dur_comp_day/60
gen tot_dur_game_day_h=tot_dur_game_day/60
gen tot_dur_comp_game_day_h=tot_dur_comp_game_day/60
gen tot_dur_sceen_day_h=tot_dur_sceen_day/60
gen tot_dur_other_sed_day_h=tot_dur_other_sed_day/60
gen tot_dur_sed_day_h=tot_dur_sed_day/60
gen tot_dur_sed_nosleep_day_h=tot_dur_sed_nosleep_day/60
gen tot_dur_sleep_nap_wd_h=tot_dur_sleep_nap_wd/60
gen tot_dur_sleep_nap_wndd_h=tot_dur_sleep_nap_wndd/60
gen tot_dur_meal_wd_h=tot_dur_meal_wd/60
gen tot_dur_meal_wndd_h=tot_dur_meal_wndd/60
gen tot_dur_tv_wd_h=dE17_1_dur_tv_wd_c/60
gen tot_dur_tv_wndd_h=dE17_2_dur_tv_wndd_c/60
gen tot_dur_comp_game_wd_h=tot_dur_comp_game_wd/60
gen tot_dur_comp_game_wndd_h=tot_dur_comp_game_wndd/60
gen tot_dur_screen_wd_h=tot_dur_screen_wd/60
gen tot_dur_screen_wndd_h=tot_dur_screen_wndd/60
gen tot_dur_other_sed_wd_h=tot_dur_other_sed_wd/60
gen tot_dur_other_sed_wndd_h=tot_dur_other_sed_wndd/60

*Additional variables other activities:
gen tot_dur_read_day_h=tot_dur_read_day / 60
gen tot_dur_house_day_h=tot_dur_house_day / 60
gen tot_dur_cari_day_h=tot_dur_cari_day / 60
gen tot_dur_hobb_day_h=tot_dur_hobb_day / 60
gen tot_dur_soc_day_h=tot_dur_soc_day / 60
gen tot_dur_music_day_h=tot_dur_music_day / 60
gen tot_dur_other_day_h=tot_dur_other_day / 60
gen dE20_1_dur_read_wd_c_h=dE20_1_dur_read_wd_c / 60
gen dE20_3_dur_house_wd_c_h=dE20_3_dur_house_wd_c / 60
gen dE20_5_dur_cari_wd_c_h=dE20_5_dur_cari_wd_c / 60
gen dE20_7_dur_hobb_wd_c_h=dE20_7_dur_hobb_wd_c / 60
gen dE20_9_dur_soc_wd_c_h=dE20_9_dur_soc_wd_c / 60
gen dE20_11_dur_music_wd_c_h=dE20_11_dur_music_wd_c / 60
gen dE20_14_dur_other_wd_c_h=dE20_14_dur_other_wd_c / 60
gen dE20_2_dur_read_wndd_c_h=dE20_2_dur_read_wndd_c / 60
gen dE20_4_dur_house_wndd_c_h=dE20_4_dur_house_wndd_c / 60
gen dE20_6_dur_cari_wndd_c_h=dE20_6_dur_cari_wndd_c / 60
gen dE20_8_dur_hobb_wndd_c_h=dE20_8_dur_hobb_wndd_c / 60
gen dE20_10_dur_soc_wndd_c_h=dE20_10_dur_soc_wndd_c / 60
gen dE20_12_dur_music_wndd_c_h=dE20_12_dur_music_wndd_c / 60
gen dE20_15_dur_other_wndd_c_h=dE20_15_dur_other_wndd_c / 60

*---> Frequencies check:

tab1 tot_dur_sleep_day_h tot_dur_sleep_nap_day_h tot_dur_meal_day_h tot_dur_transp_day_h tot_dur_tv_day_h tot_dur_comp_day_h /*
   */tot_dur_game_day_h tot_dur_comp_game_day_h tot_dur_sceen_day_h tot_dur_other_sed_day_h tot_dur_sed_day_h tot_dur_sed_nosleep_day_h /*
   */ wd_dur_sleep_dec tot_dur_sleep_nap_wd_h tot_dur_meal_wd_h tot_dur_tv_wd_h tot_dur_comp_game_wd_h tot_dur_screen_wd_h tot_dur_other_sed_wd_h /*
   */ wndd_dur_sleep_dec tot_dur_sleep_nap_wndd_h tot_dur_meal_wndd_h tot_dur_tv_wndd_h tot_dur_comp_game_wndd_h tot_dur_screen_wndd_h tot_dur_other_sed_wndd_h 

tab1 tot_dur_occ_day_h if dD10_status_occ_c==2
tab1 aver_break_occ_hour if dD10_status_occ_c==2 & tot_dur_occ_day_h > 0

tab1 aver_break_tv_hour if tot_dur_tv_day > 0

******************************************************************************************************************
*LABELLING OF KEY VARIABLES
*AVERAGE DAY
label var  tot_dur_sed_nosleep_day_h 	"Average day total sedentary time (awake time only) (hrs/day)"
label var  tot_dur_meal_day_h 			"Average day meals sedentary time (hrs/day)"
label var  tot_dur_transp_day_h			"Average day transportation sedentary time (hrs/day)"
label var  tot_dur_occ_day_h			"Average day occupational sedentary time (hrs/day)"
label var  tot_dur_sceen_day_h			"Average day screen time sedentary time (hrs/day)"
label var  tot_dur_tv_day_h				"Average day tv viewing sedentary time (hrs/day)"
label var  tot_dur_comp_game_day_h		"Average day non-occupational computer use sedentary time (hrs/day)"
label var  tot_dur_other_sed_day_h		"Average day other sedentary time (hrs/day)"
label var  tot_dur_read_day_h			"Average day sitting while reading (hrs/day)"
label var  tot_dur_house_day_h			"Average day sitting while doing household tasks (hrs/day)"
label var  tot_dur_cari_day_h			"Average day sitting while caring (hrs/day)"
label var  tot_dur_hobb_day_h			"Average day sitting for hobbies (hrs/day)"
label var  tot_dur_soc_day_h			"Average day sitting for socialising (hrs/day)"
label var  tot_dur_music_day_h			"Average day sitting while listening to music (hrs/day)"
label var  aver_break_occ_hour 			"Average day average breaks occupation (breaks/hr)"
label var  aver_break_tv_hour			"Average day average breaks tv viewing (breaks/hr)"
label var  tot_dur_sleep_nap_day_h		"Average day sleeping (hrs/day)"

*WEEKDAY
label var tot_dur_meal_wd_h 			"Weekday meals sedentary time (hrs/day)"
label var tot_dur_screen_wd_h 			"Weekday screen time sedentary time (hrs/day)"
label var tot_dur_tv_wd_h				"Weekday tv viewing sedentary time (hrs/day)"
label var tot_dur_comp_game_wd_h		"Weekday non-occupational computer use sedentary time (hrs/day)"
label var tot_dur_other_sed_wd_h		"Weekday other sedentary time (hrs/day)"
label var dE20_1_dur_read_wd_c_h		"Weekday sitting while reading (hrs/day)"
label var dE20_3_dur_house_wd_c_h		"Weekday sitting while doing household tasks (hrs/day)"
label var dE20_5_dur_cari_wd_c_h 		"Weekday sitting while caring (hrs/day)"
label var dE20_7_dur_hobb_wd_c_h 		"Weekday sitting for hobbies (hrs/day)"
label var dE20_9_dur_soc_wd_c_h 		"Weekday sitting for socialising (hrs/day)"
label var dE20_11_dur_music_wd_c_h 		"Weekday sitting while listening to music (hrs/day)"
label var tot_dur_sleep_nap_wd_h		"Weekday sleeping (hrs/day)"

*WEEKEND DAY
label var tot_dur_meal_wndd_h 			"Weekend day meals sedentary time (hrs/day)"
label var tot_dur_screen_wndd_h			"Weekend day screen time sedentary time (hrs/day)"
label var tot_dur_tv_wndd_h 			"Weekend day tv viewing sedentary time (hrs/day)"
label var tot_dur_comp_game_wndd_h		"Weekend day non-occupational computer use sedentary time (hrs/day)"
label var tot_dur_other_sed_wndd_h		"Weekend day other sedentary time (hrs/day)"
label var dE20_2_dur_read_wndd_c_h		"Weekend day sitting while reading (hrs/day)"
label var dE20_4_dur_house_wndd_c_h		"Weekend day sitting while doing household tasks (hrs/day)"
label var dE20_6_dur_cari_wndd_c_h		"Weekend day sitting while caring (hrs/day)"
label var dE20_8_dur_hobb_wndd_c_h		"Weekend day sitting for hobbies (hrs/day)"
label var dE20_10_dur_soc_wndd_c_h		"Weekend day sitting for socialising (hrs/day)"
label var dE20_12_dur_music_wndd_c_h	"Weekend day sitting while listening to music (hrs/day)"
label var tot_dur_sleep_nap_wndd_h		"Weekend day sleeping (hrs/day)"


save "`FOLDER'/`OUTPUT_FILE'", replace

STOP - THIS IS THE END OF PROCESSING
